/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import rice.Continuation;
import rice.Destructable;
import rice.Executable;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Node;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeSetListener;
import rice.pastry.ScheduledMessage;
import rice.pastry.client.PastryAppl;
import rice.pastry.commonapi.PastryEndpoint;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.Credentials;
import rice.pastry.security.PastrySecurityManager;

public abstract class PastryNode
extends Observable
implements MessageReceiver,
Node,
Destructable {
    protected NodeId myNodeId;
    private Environment myEnvironment;
    private PastrySecurityManager mySecurityManager;
    private MessageDispatch myMessageDispatch;
    private LeafSet leafSet;
    private RoutingTable routeSet;
    protected NodeHandle localhandle;
    private boolean ready;
    protected Vector apps;
    protected Logger logger;
    private boolean neverBeenReady = true;

    protected PastryNode(NodeId id, Environment e) {
        this.myEnvironment = e;
        this.myNodeId = id;
        this.ready = false;
        this.apps = new Vector();
        this.logger = e.getLogManager().getLogger(this.getClass(), null);
    }

    public rice.p2p.commonapi.NodeHandle getLocalNodeHandle() {
        return this.localhandle;
    }

    public Environment getEnvironment() {
        return this.myEnvironment;
    }

    public NodeHandle getLocalHandle() {
        return this.localhandle;
    }

    public NodeId getNodeId() {
        return this.myNodeId;
    }

    public boolean isReady() {
        return this.ready;
    }

    public MessageDispatch getMessageDispatch() {
        return this.myMessageDispatch;
    }

    public boolean isClosest(NodeId key) {
        return this.leafSet.mostSimilar(key) == 0;
    }

    public LeafSet getLeafSet() {
        return this.leafSet;
    }

    public RoutingTable getRoutingTable() {
        return this.routeSet;
    }

    public Id getId() {
        return this.getNodeId();
    }

    public IdFactory getIdFactory() {
        return new PastryIdFactory(this.getEnvironment());
    }

    public void setElements(NodeHandle lh, PastrySecurityManager sm, MessageDispatch md, LeafSet ls, RoutingTable rt) {
        this.localhandle = lh;
        this.mySecurityManager = sm;
        this.myMessageDispatch = md;
        this.leafSet = ls;
        this.routeSet = rt;
    }

    public void setMessageDispatch(MessageDispatch md) {
        this.myMessageDispatch = md;
    }

    public void setReady() {
        this.setReady(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReady(boolean r) {
        if (this.ready == r) {
            return;
        }
        if (this.logger.level <= 700) {
            this.logger.log("PastryNode.setReady(" + r + ")");
        }
        this.ready = r;
        if (this.ready) {
            this.nodeIsReady();
            this.nodeIsReady(true);
            this.setChanged();
            this.notifyObservers(new Boolean(true));
            if (this.neverBeenReady) {
                Vector tmpApps = new Vector(this.apps);
                Iterator it = tmpApps.iterator();
                while (it.hasNext()) {
                    ((PastryAppl)it.next()).notifyReady();
                }
                this.neverBeenReady = false;
            }
            this.myMessageDispatch.deliverAllBufferedMessages();
            PastryNode pastryNode = this;
            synchronized (pastryNode) {
                this.notifyAll();
            }
        } else {
            this.nodeIsReady(false);
            this.setChanged();
            this.notifyObservers(new Boolean(false));
        }
    }

    public abstract NodeHandle coalesce(NodeHandle var1);

    public abstract void nodeIsReady();

    public void nodeIsReady(boolean state) {
    }

    public abstract void initiateJoin(NodeHandle var1);

    public void addLeafSetObserver(Observer o) {
        this.leafSet.addObserver(o);
    }

    public void deleteLeafSetObserver(Observer o) {
        this.leafSet.deleteObserver(o);
    }

    public void addLeafSetListener(NodeSetListener listener) {
        this.leafSet.addNodeSetListener(listener);
    }

    public void deleteLeafSetListener(NodeSetListener listener) {
        this.leafSet.deleteNodeSetListener(listener);
    }

    public void addRouteSetObserver(Observer o) {
        this.routeSet.addObserver(o);
    }

    public void deleteRouteSetObserver(Observer o) {
        this.routeSet.deleteObserver(o);
    }

    public void addRouteSetListener(NodeSetListener listener) {
        this.routeSet.addNodeSetListener(listener);
    }

    public void removeRouteSetListener(NodeSetListener listener) {
        this.routeSet.removeNodeSetListener(listener);
    }

    public synchronized void receiveMessage(Message msg) {
        if (this.mySecurityManager.verifyMessage(msg)) {
            this.myMessageDispatch.dispatchMessage(msg);
        }
    }

    public void registerReceiver(Credentials cred, Address address, MessageReceiver receiver) {
        if (!this.mySecurityManager.verifyAddressBinding(cred, address)) {
            throw new Error("security failure");
        }
        this.myMessageDispatch.registerReceiver(address, receiver);
    }

    public void registerApp(PastryAppl app) {
        if (this.isReady()) {
            app.notifyReady();
        }
        this.apps.add(app);
    }

    public abstract ScheduledMessage scheduleMsg(Message var1, long var2);

    public abstract ScheduledMessage scheduleMsg(Message var1, long var2, long var4);

    public abstract ScheduledMessage scheduleMsgAtFixedRate(Message var1, long var2, long var4);

    public String toString() {
        return "Pastry node " + this.myNodeId.toString();
    }

    public Endpoint registerApplication(Application application, String instance) {
        return new PastryEndpoint(this, application, instance);
    }

    public Endpoint registerApplication(Application application, int port) {
        return new PastryEndpoint(this, application, port);
    }

    public void process(Executable task, Continuation command) {
        try {
            this.myEnvironment.getProcessor().process(task, command, this.myEnvironment.getSelectorManager(), this.myEnvironment.getTimeSource(), this.myEnvironment.getLogManager());
        }
        catch (Exception e) {
            command.receiveException(e);
        }
    }

    public void destroy() {
        this.myMessageDispatch.destroy();
    }

    public abstract void send(NodeHandle var1, Message var2);
}

