/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util.testing;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import rice.p2p.util.XMLObjectInputStream;
import rice.p2p.util.XMLObjectOutputStream;

public class XMLObjectStreamUnit {
    protected XMLObjectOutputStream xoos;
    protected XMLObjectInputStream xois;
    protected ByteArrayOutputStream baos;
    protected ByteArrayInputStream bais;

    public XMLObjectStreamUnit() throws IOException {
        this.reset();
    }

    protected void reset() throws IOException {
        this.baos = new ByteArrayOutputStream();
        this.xoos = new XMLObjectOutputStream(new BufferedOutputStream(this.baos));
        this.bais = null;
        this.xois = null;
    }

    protected void flip() throws IOException {
        this.xoos.close();
        this.bais = new ByteArrayInputStream(this.baos.toByteArray());
        this.xois = new XMLObjectInputStream(this.bais);
    }

    protected void testInt(int i) {
        try {
            this.xoos.writeInt(i);
            this.flip();
            int j = this.xois.readInt();
            this.reset();
            if (i != j) {
                throw new IOException("int " + j + " was not equal to " + i);
            }
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testBoolean(boolean b) {
        try {
            this.xoos.writeBoolean(b);
            this.flip();
            boolean c = this.xois.readBoolean();
            String xml = new String(this.baos.toByteArray());
            this.reset();
            if (b != c) {
                throw new IOException("boolean " + c + " was not equal to " + b + ". XML: " + xml);
            }
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testByte(byte i) {
        try {
            this.xoos.writeByte(i);
            this.flip();
            byte j = this.xois.readByte();
            this.reset();
            if (i != j) {
                throw new IOException("byte " + j + " was not equal to " + i);
            }
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testChar(char i) {
        try {
            this.xoos.writeChar(i);
            this.flip();
            char j = this.xois.readChar();
            this.reset();
            if (i != j) {
                throw new IOException("char " + j + " was not equal to " + i);
            }
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testDouble(double i) {
        try {
            this.xoos.writeDouble(i);
            this.flip();
            double j = this.xois.readDouble();
            this.reset();
            if (i != j) {
                throw new IOException("double " + j + " was not equal to " + i);
            }
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testFloat(float i) {
        try {
            this.xoos.writeFloat(i);
            this.flip();
            float j = this.xois.readFloat();
            this.reset();
            if (i != j) {
                throw new IOException("float " + j + " was not equal to " + i);
            }
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testLong(long i) {
        try {
            this.xoos.writeLong(i);
            this.flip();
            long j = this.xois.readLong();
            this.reset();
            if (i != j) {
                throw new IOException("long " + j + " was not equal to " + i);
            }
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testShort(short i) {
        try {
            this.xoos.writeShort(i);
            this.flip();
            short j = this.xois.readShort();
            this.reset();
            if (i != j) {
                throw new IOException("short " + j + " was not equal to " + i);
            }
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testMultiplePrimitives() {
        try {
            int i = -1029;
            double d = 2939.22;
            long l = 1929029389303L;
            this.xoos.writeInt(i);
            this.xoos.writeDouble(d);
            this.xoos.writeLong(l);
            this.flip();
            if (this.xois.readInt() != i || this.xois.readDouble() != d || this.xois.readLong() != l) {
                throw new IOException("Multiple primitives were not read correctly!");
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected boolean compare(Object o1, Object o2) {
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray() && o1.getClass().getComponentType().equals(o2.getClass().getComponentType())) {
            if (Array.getLength(o1) != Array.getLength(o2)) {
                return false;
            }
            if (o2.getClass().getComponentType().isPrimitive()) {
                Class<?> c = o2.getClass().getComponentType();
                if (c.equals(Integer.TYPE)) {
                    return Arrays.equals((int[])o1, (int[])o2);
                }
                if (c.equals(Boolean.TYPE)) {
                    return Arrays.equals((boolean[])o1, (boolean[])o2);
                }
                if (c.equals(Byte.TYPE)) {
                    return Arrays.equals((byte[])o1, (byte[])o2);
                }
                if (c.equals(Character.TYPE)) {
                    return Arrays.equals((char[])o1, (char[])o2);
                }
                if (c.equals(Double.TYPE)) {
                    return Arrays.equals((double[])o1, (double[])o2);
                }
                if (c.equals(Float.TYPE)) {
                    return Arrays.equals((float[])o1, (float[])o2);
                }
                if (c.equals(Long.TYPE)) {
                    return Arrays.equals((long[])o1, (long[])o2);
                }
                if (c == Short.TYPE) {
                    return Arrays.equals((short[])o1, (short[])o2);
                }
                throw new IllegalArgumentException("Class " + c + " is not primitive!");
            }
            for (int i = 0; i < Array.getLength(o1); ++i) {
                if (this.compare(Array.get(o1, i), Array.get(o2, i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void test(Object o) {
        try {
            long start = System.currentTimeMillis();
            this.xoos.writeObject(o);
            this.flip();
            long mid = System.currentTimeMillis();
            Object o2 = this.xois.readObject();
            long end = System.currentTimeMillis();
            System.out.println("WRITE: " + (mid - start) + " READ: " + (end - mid));
            if (o == o2) {
                throw new IOException("Returned object is identicial to first!");
            }
            if (!this.compare(o, o2)) {
                System.out.println("XML IS: " + new String(this.baos.toByteArray()));
                throw new IOException("Object " + o2 + " was not equal to " + o);
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testHashtable() {
        try {
            Hashtable<Object, Integer> table = new Hashtable<Object, Integer>();
            Integer i = new Integer(1020);
            table.put("monkey", i);
            table.put("cat", i);
            table.put(i, i);
            this.xoos.writeObject(table);
            this.flip();
            Hashtable table2 = (Hashtable)this.xois.readObject();
            if (table == table2) {
                throw new IOException("Returned table is identicial to first!");
            }
            if (!table.equals(table2)) {
                throw new IOException("Object " + table2 + " was not equal to " + table);
            }
            if (table2.get("monkey") != table2.get("cat")) {
                throw new IOException("Object " + table2.get("monkey") + " was not equal to " + table2.get("cat"));
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testMultipleObjects() {
        try {
            this.xoos.writeObject(new Integer(28));
            this.xoos.writeObject(new Vector());
            this.flip();
            if (!this.xois.readObject().equals(new Integer(28)) && !this.xois.readObject().equals(new Vector())) {
                throw new IOException("Objects are not equal!");
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testUnserializableObject() {
        try {
            try {
                this.xoos.writeObject(new Object());
            }
            catch (NotSerializableException e) {
                this.reset();
                return;
            }
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testByteCustomSerializer() {
        try {
            TestByteSerialization object = new TestByteSerialization();
            this.xoos.writeObject(object);
            this.flip();
            System.out.println("XML IS: " + new String(this.baos.toByteArray()));
            TestByteSerialization object2 = (TestByteSerialization)this.xois.readObject();
            if (object2 == null) {
                throw new IOException("Object was null!");
            }
            if (object2.bytes() == null) {
                throw new IOException("Object bytes was null!");
            }
            if (object2.bytes().length != 5) {
                throw new IOException("Object did not have correct length " + object2.bytes().length);
            }
            for (int i = 0; i < 4; ++i) {
                if (object.bytes()[i] == object2.bytes()[i]) continue;
                throw new IOException("Object did not have correct byte!");
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testCustomSerializer() {
        try {
            Serializable object = new Serializable(){
                private int hashCode = 83;

                public int hashCode() {
                    return this.hashCode;
                }

                private void readObject(ObjectInputStream oos) throws IOException, ClassNotFoundException {
                    this.hashCode = 100;
                }

                private void writeObject(ObjectOutputStream oos) throws IOException {
                }
            };
            this.xoos.writeObject(object);
            this.flip();
            Object object2 = this.xois.readObject();
            if (object2.hashCode() != 100) {
                throw new IOException("Object did not have correct hashCode " + object2.hashCode());
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testBrokenCustomSerializer() {
        try {
            try {
                Serializable object = new Serializable(){

                    private void writeObject(ObjectOutputStream oos) throws IOException {
                    }
                };
                this.xoos.writeObject(object);
                this.flip();
                this.xois.readObject();
            }
            catch (IOException e) {
                this.reset();
                return;
            }
            catch (ClassNotFoundException e) {
                System.out.println("test produced exception " + e);
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testUnshared() {
        try {
            Integer object = new Integer(3);
            this.xoos.writeObject(object);
            this.xoos.writeUnshared(object);
            this.xoos.writeObject(object);
            this.flip();
            Object object2 = this.xois.readObject();
            Object object3 = this.xois.readObject();
            Object object4 = this.xois.readObject();
            if (object2 == object3 || object3 == object4 || object2 != object4) {
                throw new IOException("Object did not have correct equality " + System.identityHashCode(object2) + " " + System.identityHashCode(object3) + " " + System.identityHashCode(object4));
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testExternal() {
        try {
            TestExternalizable object = new TestExternalizable();
            this.xoos.writeObject(object);
            this.flip();
            TestExternalizable object2 = (TestExternalizable)this.xois.readObject();
            if (object2.getNum() != 299) {
                throw new IOException("Object did not have correct num " + object2.getNum());
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testSubExternal() {
        try {
            TestSubExternalizable object = new TestSubExternalizable(null);
            this.xoos.writeObject(object);
            this.flip();
            TestSubExternalizable object2 = (TestSubExternalizable)this.xois.readObject();
            if (object2.getNum() != 1000) {
                throw new IOException("Object did not have correct num " + object2.getNum());
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testPutFields() {
        try {
            TestPutFields object = new TestPutFields();
            this.xoos.writeObject(object);
            this.flip();
            TestPutFields object2 = (TestPutFields)this.xois.readObject();
            if (object2.getNum() != 10001 || object2.getNum2() != 99) {
                throw new IOException("Object did not have correct num " + object2.getNum() + " " + object2.getNum2());
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testUnreadData() {
        try {
            TestUnreadData object = new TestUnreadData();
            this.xoos.writeObject(object);
            this.flip();
            TestUnreadData object2 = (TestUnreadData)this.xois.readObject();
            if (object2.getNum() != object.getNum()) {
                throw new IOException("Object did not have correct num " + object2.getNum() + " " + object.getNum());
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testWriteReplace() {
        try {
            TestReplace object = new TestReplace();
            this.xoos.writeObject(object);
            this.flip();
            Object object2 = this.xois.readObject();
            if (!(object2 instanceof TestReplace2)) {
                throw new IOException("Object did not have correct class " + object2.getClass());
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testReadResolve() {
        try {
            TestResolve object = new TestResolve();
            this.xoos.writeObject(object);
            this.flip();
            Object object2 = this.xois.readObject();
            if (!(object2 instanceof TestResolve2)) {
                throw new IOException("Object did not have correct class " + object2.getClass());
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testInheritedWriteReplace() {
        try {
            TestReplace3 object = new TestReplace3();
            this.xoos.writeObject(object);
            this.flip();
            Object object2 = this.xois.readObject();
            if (!(object2 instanceof TestReplace2)) {
                throw new IOException("Object did not have correct class " + object2.getClass());
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testInheritedReadResolve() {
        try {
            TestResolve3 object = new TestResolve3();
            this.xoos.writeObject(object);
            this.flip();
            Object object2 = this.xois.readObject();
            if (!(object2 instanceof TestResolve2)) {
                throw new IOException("Object did not have correct class " + object2.getClass());
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    protected void testSerialPersistentFields() {
        try {
            TestSerialPersistentFields object = new TestSerialPersistentFields();
            this.xoos.writeObject(object);
            this.flip();
            TestSerialPersistentFields object2 = (TestSerialPersistentFields)this.xois.readObject();
            if (!object2.getNum1().equals(new Integer(1)) || object2.getNum2() != null) {
                throw new IOException("Object did not have correct nums " + object2.getNum1() + " " + object2.getNum2());
            }
            this.reset();
        }
        catch (IOException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("test produced exception " + e);
            e.printStackTrace();
        }
    }

    public void start() {
        this.testInt(20930);
        this.testInt(0);
        this.testInt(-29384);
        this.testBoolean(true);
        this.testBoolean(false);
        this.testByte((byte)0);
        this.testByte((byte)10);
        this.testByte((byte)-1);
        this.testChar('A');
        this.testChar('B');
        this.testChar('z');
        this.testChar('1');
        this.testChar('.');
        this.testChar('&');
        this.testChar('<');
        this.testChar('>');
        this.testChar(' ');
        this.testChar('\"');
        this.testChar('\'');
        this.testDouble(0.0);
        this.testDouble(-1029.2);
        this.testDouble(17.0);
        this.testDouble(182.29938);
        this.testFloat(0.0f);
        this.testFloat(29.239f);
        this.testFloat(11.1029f);
        this.testFloat(-1902.1f);
        this.testLong(1920L);
        this.testLong(0L);
        this.testLong(192983783739892L);
        this.testLong(-1299L);
        this.testLong(-19282738339299L);
        this.testShort((short)28);
        this.testShort((short)1829);
        this.testShort((short)0);
        this.testMultiplePrimitives();
        this.test(new Integer(5));
        this.test(new Long(2837L));
        this.test(new Vector());
        this.test("monkey");
        this.test("");
        this.test("blah blah balh\n blah blah ablh");
        this.test("blah blah balh\n\t\r\n\r\t\r blah blah ablh");
        this.test("<monkey>");
        this.test("<>&;'\"");
        this.testHashtable();
        this.testMultipleObjects();
        this.testUnserializableObject();
        this.testByteCustomSerializer();
        this.testCustomSerializer();
        this.testBrokenCustomSerializer();
        this.testSerialPersistentFields();
        this.testUnshared();
        this.testExternal();
        this.testSubExternal();
        this.testPutFields();
        this.testUnreadData();
        this.testWriteReplace();
        this.testReadResolve();
        this.testInheritedWriteReplace();
        this.testInheritedReadResolve();
        this.test(new byte[7847]);
        this.test(new byte[4][6]);
    }

    public static void main(String[] args) throws IOException {
        XMLObjectStreamUnit test = new XMLObjectStreamUnit();
        test.start();
    }

    public static class TestSerialPersistentFields
    implements Serializable {
        private Integer num1 = new Integer(1);
        private Integer num2 = new Integer(2);
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("num1", Integer.class)};

        public Integer getNum1() {
            return this.num1;
        }

        public Integer getNum2() {
            return this.num2;
        }
    }

    public static class TestResolve3
    extends TestResolve {
    }

    public static class TestResolve2
    extends TestResolve {
    }

    public static class TestResolve
    implements Serializable {
        protected Object readResolve() {
            return new TestResolve2();
        }
    }

    public static class TestReplace3
    extends TestReplace {
    }

    public static class TestReplace2
    extends TestReplace {
    }

    public static class TestReplace
    implements Serializable {
        protected Object writeReplace() {
            return new TestReplace2();
        }
    }

    public static class TestUnreadData
    implements Serializable {
        int num = 293;

        public int getNum() {
            return this.num;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.defaultWriteObject();
            oos.writeInt(10);
            oos.writeObject("niondco");
            oos.writeObject(new Vector());
        }
    }

    public static class TestPutFields
    implements Serializable {
        int num = 0;
        Integer num2 = null;

        public int getNum() {
            return this.num;
        }

        public int getNum2() {
            return this.num2;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            ObjectOutputStream.PutField pf = oos.putFields();
            pf.put("num", 10001);
            pf.put("num2", new Integer(99));
            pf.put("blah", 100);
            oos.writeFields();
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField gf = ois.readFields();
            this.num = gf.get("num", 0);
            this.num2 = (Integer)gf.get("num2", new Integer(0));
            gf.get("blah", 0);
            if (!gf.defaulted("monkey")) {
                throw new IOException("Field monkey was not defaulted!");
            }
            if (gf.defaulted("num")) {
                throw new IOException("Field num was defaulted!");
            }
            if (gf.defaulted("num2")) {
                throw new IOException("Field num was defaulted!");
            }
        }
    }

    public static class TestSubExternalizable
    extends TestExternalizable {
        public TestSubExternalizable(Object o) {
        }

        private TestSubExternalizable() {
        }

        public void writeExternal(ObjectOutput o) throws IOException {
            super.writeExternal(o);
            o.writeInt(1000);
        }

        public void readExternal(ObjectInput i) throws IOException, ClassNotFoundException {
            super.readExternal(i);
            this.num = i.readInt();
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            throw new IllegalArgumentException("READ OBJECT SHOULD NOT BE CALLED!");
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            throw new IllegalArgumentException("WRITE OBJECT SHOULD NOT BE CALLED!");
        }
    }

    public static class TestExternalizable
    implements Externalizable {
        protected int num = 199;

        public int getNum() {
            return this.num;
        }

        public void writeExternal(ObjectOutput o) throws IOException {
            o.writeInt(this.num + 100);
            o.writeInt(2000);
        }

        public void readExternal(ObjectInput i) throws IOException, ClassNotFoundException {
            this.num = i.readInt();
            i.readInt();
        }
    }

    public static class TestByteSerialization
    implements Serializable {
        private transient byte[] bytes = new byte[]{23, 19, 49, 0};

        public byte[] bytes() {
            return this.bytes;
        }

        private void readObject(ObjectInputStream oos) throws IOException, ClassNotFoundException {
            this.bytes = new byte[5];
            oos.read(this.bytes, 0, 5);
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.write(this.bytes);
        }
    }
}

