/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import rice.p2p.util.SoftHashMap;
import rice.p2p.util.XMLReader;
import sun.reflect.ReflectionFactory;

public class XMLObjectInputStream
extends ObjectInputStream {
    protected XMLReader reader;
    protected Hashtable references;
    protected Stack currentObjects;
    protected Stack currentClasses;
    protected ReflectionFactory reflFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
    protected ValidationList vlist;
    protected int depth;
    protected static SoftHashMap READ_RESOLVES = new SoftHashMap();
    protected static SoftHashMap READ_OBJECTS = new SoftHashMap();
    protected static SoftHashMap CONSTRUCTORS = new SoftHashMap();

    public XMLObjectInputStream(InputStream in) throws IOException {
        this.reader = new XMLReader(new InputStreamReader(in));
        this.currentObjects = new Stack();
        this.currentClasses = new Stack();
        this.references = new Hashtable();
        this.vlist = new ValidationList();
        this.depth = 0;
        this.readStreamHeader();
    }

    protected Constructor getSerializableConstructor(Class c) throws IOException, NoSuchMethodException {
        Class initCl = c;
        while (Serializable.class.isAssignableFrom(initCl)) {
            initCl = initCl.getSuperclass();
        }
        Constructor<Object> cons = initCl.getDeclaredConstructor(new Class[0]);
        cons = this.reflFactory.newConstructorForSerialization(c, cons);
        cons.setAccessible(true);
        return cons;
    }

    protected Class getClass(String name) throws ClassNotFoundException {
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        return Class.forName(name);
    }

    protected Object getReference(String reference) {
        return this.references.get(reference);
    }

    protected void readStreamHeader() throws IOException {
        this.reader.readHeader();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public void reset() throws IOException {
        this.references = new Hashtable();
        this.vlist.clear();
    }

    public int read() throws IOException {
        return this.readByte();
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        this.reader.readStartTag("base64");
        byte[] bytes = this.reader.readBase64();
        int written = length < bytes.length ? length : bytes.length;
        System.arraycopy(bytes, 0, b, offset, written);
        return written;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int offset, int length) throws IOException {
        this.read(b, offset, length);
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort();
    }

    public int readInt() throws IOException {
        this.reader.readStartTag("primitive");
        return this.readIntHelper();
    }

    public boolean readBoolean() throws IOException {
        this.reader.readStartTag("primitive");
        return this.readBooleanHelper();
    }

    public byte readByte() throws IOException {
        this.reader.readStartTag("primitive");
        return this.readByteHelper();
    }

    public char readChar() throws IOException {
        this.reader.readStartTag("primitive");
        return this.readCharHelper();
    }

    public double readDouble() throws IOException {
        this.reader.readStartTag("primitive");
        return this.readDoubleHelper();
    }

    public float readFloat() throws IOException {
        this.reader.readStartTag("primitive");
        return this.readFloatHelper();
    }

    public long readLong() throws IOException {
        this.reader.readStartTag("primitive");
        return this.readLongHelper();
    }

    public short readShort() throws IOException {
        this.reader.readStartTag("primitive");
        return this.readShortHelper();
    }

    public String readUTF() throws IOException {
        try {
            return (String)this.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("ReadUTF caused " + e);
        }
    }

    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        this.reader.readStartTag();
        Object result = this.readObjectHelper();
        if (this.depth == 0) {
            this.vlist.doCallbacks();
        }
        return result;
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        this.reader.readStartTag();
        Object result = this.readUnsharedHelper(false);
        if (this.depth == 0) {
            this.vlist.doCallbacks();
        }
        return result;
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
        if (this.currentObjects.peek() == null) {
            throw new NotActiveException("defaultReadObject called with empty stack!");
        }
        this.readFields(this.currentObjects.peek(), (Class)this.currentClasses.peek());
    }

    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        if (this.currentObjects.peek() != null) {
            return this.readGetFields();
        }
        throw new NotActiveException("readFields called with empty stack!");
    }

    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
        if (this.currentObjects.peek() == null) {
            throw new NotActiveException("registerValidation called with empty stack!");
        }
        this.vlist.register(obj, prio);
    }

    protected Object newInstance(Class c) throws IOException {
        try {
            Constructor cons = (Constructor)CONSTRUCTORS.get(c);
            if (cons == null) {
                cons = Externalizable.class.isAssignableFrom(c) ? c.getDeclaredConstructor(new Class[0]) : this.getSerializableConstructor(c);
                cons.setAccessible(true);
                CONSTRUCTORS.put(c, cons);
            }
            return cons.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new IOException("Could not instanciate new class " + c);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Could not instanciate new class " + c);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Could not instanciate new class " + c);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Could not instanciate new class " + c);
        }
    }

    protected void putReference(String reference, Object o) {
        this.references.put(reference, o);
    }

    protected String readPrimitive(String type) throws IOException {
        this.reader.assertStartTag("primitive");
        this.reader.assertAttribute("type", type);
        String value = this.reader.getAttribute("value");
        this.reader.readEndTag("primitive");
        return value;
    }

    protected int readIntHelper() throws IOException {
        return Integer.parseInt(this.readPrimitive("int"));
    }

    protected boolean readBooleanHelper() throws IOException {
        return this.readPrimitive("boolean").equals("true");
    }

    protected byte readByteHelper() throws IOException {
        return Byte.parseByte(this.readPrimitive("byte"));
    }

    protected char readCharHelper() throws IOException {
        return this.readPrimitive("char").charAt(0);
    }

    protected double readDoubleHelper() throws IOException {
        return Double.parseDouble(this.readPrimitive("double"));
    }

    protected float readFloatHelper() throws IOException {
        return Float.parseFloat(this.readPrimitive("float"));
    }

    protected long readLongHelper() throws IOException {
        return Long.parseLong(this.readPrimitive("long"));
    }

    protected short readShortHelper() throws IOException {
        return Short.parseShort(this.readPrimitive("short"));
    }

    protected Object readObjectHelper() throws IOException, ClassNotFoundException {
        this.reader.assertStartTag();
        ++this.depth;
        Object result = null;
        result = this.reader.getStartTag().equals("reference") ? this.readReference() : (this.reader.getStartTag().equals("null") ? this.readNull() : this.readUnsharedHelper(true));
        --this.depth;
        return result;
    }

    protected Object readUnsharedHelper(boolean shared) throws IOException, ClassNotFoundException {
        this.reader.assertStartTag();
        if (this.reader.getStartTag().equals("string")) {
            return this.readString(shared);
        }
        if (this.reader.getStartTag().equals("array")) {
            return this.readArray(shared);
        }
        if (this.reader.getStartTag().equals("object")) {
            return this.readOrdinaryObject(shared);
        }
        throw new IOException("Unknown element name " + this.reader.getStartTag());
    }

    protected Object readReference() throws IOException, ClassNotFoundException {
        this.reader.assertStartTag("reference");
        Object result = this.getReference(this.reader.getAttribute("idref"));
        if (result == null) {
            throw new IOException("Invalid reference " + this.reader.getAttribute("idref") + " found.");
        }
        this.reader.readEndTag("reference");
        return result;
    }

    protected Object readNull() throws IOException, ClassNotFoundException {
        this.reader.assertStartTag("null");
        this.reader.readEndTag("null");
        return null;
    }

    protected Object readString(boolean shared) throws IOException, ClassNotFoundException {
        this.reader.assertStartTag("string");
        String result = new String(this.reader.getAttribute("value"));
        if (shared && this.reader.getAttribute("id") != null) {
            this.putReference(this.reader.getAttribute("id"), result);
        }
        this.reader.readEndTag("string");
        return result;
    }

    protected Object readOrdinaryObject(boolean shared) throws IOException, ClassNotFoundException {
        this.reader.assertStartTag("object");
        Class<?> c = Class.forName(this.reader.getAttribute("class"));
        String id = this.reader.getAttribute("id");
        if (!Serializable.class.isAssignableFrom(c)) {
            throw new NotSerializableException(c.getName());
        }
        Object o = this.newInstance(c);
        if (shared && id != null) {
            this.putReference(id, o);
        }
        if (Externalizable.class.isAssignableFrom(c)) {
            ((Externalizable)o).readExternal(this);
            this.reader.step();
        } else {
            this.reader.step();
            while (!this.reader.isEndTag()) {
                this.readClass(o);
                this.reader.step();
            }
        }
        this.reader.assertEndTag("object");
        Method method = XMLObjectInputStream.getReadResolve(c);
        try {
            if (method != null) {
                o = method.invoke(o, new Object[0]);
                if (shared && id != null) {
                    this.putReference(id, o);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new IOException("ReadResolve caused " + e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("ReadResolve caused " + e);
        }
        return o;
    }

    protected Object readClass(Object o) throws IOException, ClassNotFoundException {
        this.reader.assertStartTag("declaredClass");
        Class<?> c = Class.forName(this.reader.getAttribute("class"));
        Method method = XMLObjectInputStream.getReadObject(c);
        if (method != null) {
            try {
                this.currentObjects.push(o);
                this.currentClasses.push(c);
                method.invoke(o, this);
                this.currentObjects.pop();
                this.currentClasses.pop();
                this.readUnreadOptionalData();
            }
            catch (InvocationTargetException e) {
                System.out.println(e.getTargetException().getMessage());
                e.getTargetException().printStackTrace();
                throw new IOException("InvocationTargetException thrown! " + e.getTargetException());
            }
            catch (IllegalAccessException e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
                throw new IOException("IllegalAccessException thrown! " + e);
            }
        } else {
            this.readFields(o, c);
            this.readUnreadOptionalData();
        }
        this.reader.assertEndTag("declaredClass");
        return o;
    }

    protected void readUnreadOptionalData() throws IOException, ClassNotFoundException {
        this.reader.step();
        while (!this.reader.isEndTag()) {
            if (this.reader.getStartTag().equals("primitive")) {
                this.reader.readEndTag("primitive");
            } else if (this.reader.getStartTag().equals("base64")) {
                this.reader.readEndTag("base64");
            } else {
                this.readObjectHelper();
            }
            this.reader.step();
        }
    }

    protected GetField readGetFields() throws IOException, ClassNotFoundException {
        this.reader.readStartTag("default");
        GetField g = new GetField();
        this.reader.step();
        while (!this.reader.isEndTag()) {
            this.readGetField(g);
            this.reader.step();
        }
        this.reader.assertEndTag("default");
        return g;
    }

    protected void readGetField(GetField g) throws IOException, ClassNotFoundException {
        this.reader.assertStartTag();
        String name = this.reader.getAttribute("field");
        if (name == null) {
            throw new IOException("Could not read field " + this.reader.getStartTag() + ", as field attribute was null!");
        }
        if (this.reader.getStartTag().equals("primitive")) {
            this.readPrimitiveGetField(g);
        } else {
            g.put(name, this.readObjectHelper());
        }
    }

    protected void readPrimitiveGetField(GetField g) throws IOException, ClassNotFoundException {
        this.reader.assertStartTag("primitive");
        String name = this.reader.getAttribute("field");
        if (name == null) {
            throw new IOException("Could not read primitive field " + this.reader.getAttribute("type") + ", as field attribute was null!");
        }
        Class c = this.getClass(this.reader.getAttribute("type"));
        if (c.equals(Integer.TYPE)) {
            g.put(name, this.readIntHelper());
        } else if (c.equals(Boolean.TYPE)) {
            g.put(name, this.readBooleanHelper());
        } else if (c.equals(Byte.TYPE)) {
            g.put(name, this.readByteHelper());
        } else if (c.equals(Character.TYPE)) {
            g.put(name, this.readCharHelper());
        } else if (c.equals(Double.TYPE)) {
            g.put(name, this.readDoubleHelper());
        } else if (c.equals(Float.TYPE)) {
            g.put(name, this.readFloatHelper());
        } else if (c.equals(Long.TYPE)) {
            g.put(name, this.readLongHelper());
        } else if (c.equals(Short.TYPE)) {
            g.put(name, this.readShortHelper());
        } else {
            throw new IllegalArgumentException("Field " + name + " is not primitive!");
        }
    }

    protected void readFields(Object o, Class c) throws IOException, ClassNotFoundException {
        this.reader.readStartTag("default");
        this.reader.step();
        while (!this.reader.isEndTag()) {
            this.readField(o, c);
            this.reader.step();
        }
        this.reader.assertEndTag("default");
    }

    protected void readField(Object o, Class c) throws IOException, ClassNotFoundException {
        this.reader.assertStartTag();
        String field = this.reader.getAttribute("field");
        try {
            Field f = c.getDeclaredField(this.reader.getAttribute("field"));
            f.setAccessible(true);
            int mask = 8;
            if ((f.getModifiers() & mask) != 0) {
                throw new NoSuchFieldException("Field read was static!");
            }
            if (this.reader.getStartTag().equals("primitive")) {
                this.readPrimitiveField(o, f);
            } else {
                f.set(o, this.readObjectHelper());
            }
        }
        catch (NoSuchFieldException e) {
            if (this.reader.getStartTag().equals("primitive")) {
                this.reader.readEndTag("primitive");
            } else {
                this.readObjectHelper();
            }
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
            System.err.println("COULD NOT SET FIELD " + field + " OF " + o.getClass().getName() + " - SKIPPING.  THIS SHOULD NOT HAPPEN!" + e);
            e.printStackTrace();
        }
    }

    protected void readPrimitiveField(Object o, Field f) throws IOException, IllegalAccessException {
        this.reader.assertStartTag("primitive");
        if (f.getType().equals(Integer.TYPE)) {
            f.setInt(o, this.readIntHelper());
        } else if (f.getType().equals(Boolean.TYPE)) {
            f.setBoolean(o, this.readBooleanHelper());
        } else if (f.getType().equals(Byte.TYPE)) {
            f.setByte(o, this.readByteHelper());
        } else if (f.getType().equals(Character.TYPE)) {
            f.setChar(o, this.readCharHelper());
        } else if (f.getType().equals(Double.TYPE)) {
            f.setDouble(o, this.readDoubleHelper());
        } else if (f.getType().equals(Float.TYPE)) {
            f.setFloat(o, this.readFloatHelper());
        } else if (f.getType().equals(Long.TYPE)) {
            f.setLong(o, this.readLongHelper());
        } else if (f.getType().equals(Short.TYPE)) {
            f.setInt(o, this.readShortHelper());
        } else {
            throw new IllegalArgumentException("Field " + f + " is not primitive!");
        }
    }

    protected Object readArray(boolean shared) throws IOException, ClassNotFoundException {
        this.reader.assertStartTag("array");
        Class c = this.getClass(this.reader.getAttribute("base"));
        int length = Integer.valueOf(this.reader.getAttribute("length"));
        int dim = Integer.valueOf(this.reader.getAttribute("dim"));
        Object result = Array.newInstance(c, length);
        if (shared && this.reader.getAttribute("id") != null) {
            this.putReference(this.reader.getAttribute("id"), result);
        }
        for (int i = 0; i < length; ++i) {
            if (c.equals(Integer.TYPE)) {
                Array.setInt(result, i, this.readInt());
                continue;
            }
            if (c.equals(Boolean.TYPE)) {
                Array.setBoolean(result, i, this.readBoolean());
                continue;
            }
            if (c.equals(Byte.TYPE)) {
                Array.setByte(result, i, this.readByte());
                continue;
            }
            if (c.equals(Character.TYPE)) {
                Array.setChar(result, i, this.readChar());
                continue;
            }
            if (c.equals(Double.TYPE)) {
                Array.setDouble(result, i, this.readDouble());
                continue;
            }
            if (c.equals(Float.TYPE)) {
                Array.setFloat(result, i, this.readFloat());
                continue;
            }
            if (c.equals(Long.TYPE)) {
                Array.setLong(result, i, this.readLong());
                continue;
            }
            if (c.equals(Short.TYPE)) {
                Array.setShort(result, i, this.readShort());
                continue;
            }
            Array.set(result, i, this.readObject());
        }
        this.reader.readEndTag("array");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method getReadResolve(Class cl) {
        SoftHashMap softHashMap = READ_RESOLVES;
        synchronized (softHashMap) {
            Class defCl;
            if (READ_RESOLVES.containsKey(cl)) {
                return (Method)READ_RESOLVES.get(cl);
            }
            Method meth = null;
            for (defCl = cl; defCl != null; defCl = defCl.getSuperclass()) {
                try {
                    meth = defCl.getDeclaredMethod("readResolve", new Class[0]);
                    break;
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
            }
            if (meth == null) {
                READ_RESOLVES.put(cl, (Object)null);
                return null;
            }
            meth.setAccessible(true);
            int mods = meth.getModifiers();
            if ((mods & 0x408) != 0) {
                READ_RESOLVES.put(cl, (Object)null);
                return null;
            }
            if ((mods & 5) != 0) {
                READ_RESOLVES.put(cl, meth);
                return meth;
            }
            if ((mods & 2) != 0) {
                if (cl == defCl) {
                    READ_RESOLVES.put(cl, meth);
                    return meth;
                }
                READ_RESOLVES.put(cl, (Object)null);
                return null;
            }
            READ_RESOLVES.put(cl, meth);
            return meth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method getReadObject(Class cl) {
        SoftHashMap softHashMap = READ_OBJECTS;
        synchronized (softHashMap) {
            if (READ_OBJECTS.containsKey(cl)) {
                return (Method)READ_OBJECTS.get(cl);
            }
            try {
                Method method = cl.getDeclaredMethod("readObject", ObjectInputStream.class);
                method.setAccessible(true);
                READ_OBJECTS.put(cl, method);
                return method;
            }
            catch (NoSuchMethodException e) {
                READ_OBJECTS.put(cl, (Object)null);
                return null;
            }
        }
    }

    private static class ValidationList {
        private Callback list;

        ValidationList() {
        }

        void register(ObjectInputValidation obj, int priority) throws InvalidObjectException {
            if (obj == null) {
                throw new InvalidObjectException("null callback");
            }
            Callback prev = null;
            Callback cur = this.list;
            while (cur != null && priority < cur.priority) {
                prev = cur;
                cur = cur.next;
            }
            if (prev != null) {
                prev.next = new Callback(obj, priority, cur);
            } else {
                this.list = new Callback(obj, priority, this.list);
            }
        }

        void doCallbacks() throws InvalidObjectException {
            try {
                while (this.list != null) {
                    this.list.obj.validateObject();
                    this.list = this.list.next;
                }
            }
            catch (InvalidObjectException ex) {
                this.list = null;
                throw ex;
            }
        }

        public void clear() {
            this.list = null;
        }

        private static class Callback {
            final ObjectInputValidation obj;
            final int priority;
            Callback next;

            Callback(ObjectInputValidation obj, int priority, Callback next) {
                this.obj = obj;
                this.priority = priority;
                this.next = next;
            }
        }
    }

    public class GetField
    extends ObjectInputStream.GetField {
        protected HashMap primitives = new HashMap();
        protected HashMap objects = new HashMap();

        public boolean get(String name, boolean value) {
            if (this.primitives.get(name) == null) {
                return value;
            }
            return (Boolean)this.primitives.get(name);
        }

        public byte get(String name, byte value) {
            if (this.primitives.get(name) == null) {
                return value;
            }
            return (Byte)this.primitives.get(name);
        }

        public char get(String name, char value) {
            if (this.primitives.get(name) == null) {
                return value;
            }
            return ((Character)this.primitives.get(name)).charValue();
        }

        public double get(String name, double value) {
            if (this.primitives.get(name) == null) {
                return value;
            }
            return (Double)this.primitives.get(name);
        }

        public float get(String name, float value) {
            if (this.primitives.get(name) == null) {
                return value;
            }
            return ((Float)this.primitives.get(name)).floatValue();
        }

        public int get(String name, int value) {
            if (this.primitives.get(name) == null) {
                return value;
            }
            return (Integer)this.primitives.get(name);
        }

        public long get(String name, long value) {
            if (this.primitives.get(name) == null) {
                return value;
            }
            return (Long)this.primitives.get(name);
        }

        public short get(String name, short value) {
            if (this.primitives.get(name) == null) {
                return value;
            }
            return (Short)this.primitives.get(name);
        }

        public Object get(String name, Object value) {
            if (this.objects.get(name) == null) {
                return value;
            }
            return this.objects.get(name);
        }

        public ObjectStreamClass getObjectStreamClass() {
            throw new UnsupportedOperationException("CANNOT GET THE OBJECT STREAM CLASS!");
        }

        public boolean defaulted(String name) {
            return !this.primitives.containsKey(name) && !this.objects.containsKey(name);
        }

        protected void put(String name, boolean value) {
            this.primitives.put(name, new Boolean(value));
        }

        protected void put(String name, byte value) {
            this.primitives.put(name, new Byte(value));
        }

        protected void put(String name, char value) {
            this.primitives.put(name, new Character(value));
        }

        protected void put(String name, double value) {
            this.primitives.put(name, new Double(value));
        }

        protected void put(String name, float value) {
            this.primitives.put(name, new Float(value));
        }

        protected void put(String name, int value) {
            this.primitives.put(name, new Integer(value));
        }

        protected void put(String name, long value) {
            this.primitives.put(name, new Long(value));
        }

        protected void put(String name, short value) {
            this.primitives.put(name, new Short(value));
        }

        protected void put(String name, Object value) {
            this.objects.put(name, value);
        }
    }
}

