/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class RedBlackMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    private Comparator comparator = null;
    private transient Entry root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    private volatile transient Set entrySet = null;
    private volatile transient Set keySet = null;
    private volatile transient Collection values = null;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    public RedBlackMap() {
    }

    public RedBlackMap(Comparator c) {
        this.comparator = c;
    }

    public RedBlackMap(Map m) {
        this.putAll(m);
    }

    public RedBlackMap(SortedMap m) {
        this.comparator = m.comparator();
        try {
            this.buildFromSorted(m.size(), m.entrySet().iterator(), null, null);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public synchronized Object get(Object key) {
        Entry p = this.getEntry(key);
        return p == null ? null : p.value;
    }

    private synchronized Entry getEntry(Object key) {
        Entry p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp == 0) {
                return p;
            }
            if (cmp < 0) {
                p = p.left;
                continue;
            }
            p = p.right;
        }
        return null;
    }

    private synchronized Entry getCeilEntry(Object key) {
        Entry p = this.root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p.key)) == 0) {
                return p;
            }
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                return p;
            }
            if (p.right == null) break;
            p = p.right;
        }
        Entry parent = p.parent;
        Entry ch = p;
        while (parent != null && ch == parent.right) {
            ch = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private synchronized Entry getPrecedingEntry(Object key) {
        Entry p = this.root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p.key)) > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (p.left == null) break;
            p = p.left;
        }
        Entry parent = p.parent;
        Entry ch = p;
        while (parent != null && ch == parent.left) {
            ch = parent;
            parent = parent.parent;
        }
        return parent;
    }

    public Object getKey(Object key) {
        if (key == null) {
            return null;
        }
        Entry p = this.getEntry(key);
        if (p == null) {
            return null;
        }
        return p.key;
    }

    private void incrementSize() {
        ++this.modCount;
        ++this.size;
    }

    private void decrementSize() {
        ++this.modCount;
        --this.size;
    }

    public int size() {
        return this.size;
    }

    public synchronized boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    public synchronized boolean containsValue(Object value) {
        return this.root == null ? false : (value == null ? this.valueSearchNull(this.root) : this.valueSearchNonNull(this.root, value));
    }

    private boolean valueSearchNull(Entry n) {
        if (n.value == null) {
            return true;
        }
        return n.left != null && this.valueSearchNull(n.left) || n.right != null && this.valueSearchNull(n.right);
    }

    private boolean valueSearchNonNull(Entry n, Object value) {
        if (value.equals(n.value)) {
            return true;
        }
        return n.left != null && this.valueSearchNonNull(n.left, value) || n.right != null && this.valueSearchNonNull(n.right, value);
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public synchronized Object firstKey() {
        return RedBlackMap.key(this.firstEntry());
    }

    public synchronized Object lastKey() {
        return RedBlackMap.key(this.lastEntry());
    }

    public synchronized void putAll(Map map) {
        Comparator c;
        int mapSize = map.size();
        if (this.size == 0 && mapSize != 0 && map instanceof SortedMap && ((c = ((SortedMap)map).comparator()) == this.comparator || c != null && ((Object)c).equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(mapSize, map.entrySet().iterator(), null, null);
            }
            catch (IOException cannotHappen) {
            }
            catch (ClassNotFoundException cannotHappen) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    public synchronized Object put(Object key, Object value) {
        Entry t = this.root;
        if (t == null) {
            this.incrementSize();
            this.root = new Entry(key, value, null);
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, t.key)) == 0) {
                return t.setValue(value);
            }
            if (cmp < 0) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                this.incrementSize();
                t.left = new Entry(key, value, t);
                this.fixAfterInsertion(t.left);
                return null;
            }
            if (t.right == null) break;
            t = t.right;
        }
        this.incrementSize();
        t.right = new Entry(key, value, t);
        this.fixAfterInsertion(t.right);
        return null;
    }

    public synchronized Object remove(Object key) {
        Entry p = this.getEntry(key);
        if (p == null) {
            return null;
        }
        Object oldValue = p.value;
        this.deleteEntry(p);
        return oldValue;
    }

    public synchronized void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    public synchronized Object clone() {
        RedBlackMap clone = null;
        try {
            clone = (RedBlackMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.root = null;
        clone.size = 0;
        clone.modCount = 0;
        clone.entrySet = null;
        try {
            clone.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clone;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return new KeyIterator();
                }

                public int size() {
                    return RedBlackMap.this.size();
                }

                public boolean contains(Object o) {
                    return RedBlackMap.this.containsKey(o);
                }

                public boolean remove(Object o) {
                    int oldSize = RedBlackMap.this.size;
                    RedBlackMap.this.remove(o);
                    return RedBlackMap.this.size != oldSize;
                }

                public void clear() {
                    RedBlackMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return RedBlackMap.this.size();
                }

                public boolean contains(Object o) {
                    Entry e = RedBlackMap.this.firstEntry();
                    while (e != null) {
                        if (RedBlackMap.valEquals(e.getValue(), o)) {
                            return true;
                        }
                        e = RedBlackMap.this.successor(e);
                    }
                    return false;
                }

                public boolean remove(Object o) {
                    Entry e = RedBlackMap.this.firstEntry();
                    while (e != null) {
                        if (RedBlackMap.valEquals(e.getValue(), o)) {
                            RedBlackMap.this.deleteEntry(e);
                            return true;
                        }
                        e = RedBlackMap.this.successor(e);
                    }
                    return false;
                }

                public void clear() {
                    RedBlackMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new EntryIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object value = entry.getValue();
                    Entry p = RedBlackMap.this.getEntry(entry.getKey());
                    return p != null && RedBlackMap.valEquals(p.getValue(), value);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object value = entry.getValue();
                    Entry p = RedBlackMap.this.getEntry(entry.getKey());
                    if (p != null && RedBlackMap.valEquals(p.getValue(), value)) {
                        RedBlackMap.this.deleteEntry(p);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return RedBlackMap.this.size();
                }

                public void clear() {
                    RedBlackMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        if (this.compare(fromKey, toKey) <= 0) {
            return new SubMap(fromKey, toKey);
        }
        return new SubWrappedMap(fromKey, toKey);
    }

    public SortedMap headMap(Object toKey) {
        return new SubMap(toKey, true);
    }

    public SortedMap tailMap(Object fromKey) {
        return new SubMap(fromKey, false);
    }

    private int compare(Object k1, Object k2) {
        return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
    }

    private Entry firstEntry() {
        Entry p = this.root;
        if (p != null) {
            while (p.left != null) {
                p = p.left;
            }
        }
        return p;
    }

    private Entry lastEntry() {
        Entry p = this.root;
        if (p != null) {
            while (p.right != null) {
                p = p.right;
            }
        }
        return p;
    }

    private Entry successor(Entry t) {
        if (t == null) {
            return null;
        }
        if (t.deleted) {
            return this.getCeilEntry(t.key);
        }
        if (t.right != null) {
            Entry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        Entry p = t.parent;
        Entry ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private void rotateLeft(Entry p) {
        Entry r = p.right;
        p.right = r.left;
        if (r.left != null) {
            r.left.parent = p;
        }
        r.parent = p.parent;
        if (p.parent == null) {
            this.root = r;
        } else if (p.parent.left == p) {
            p.parent.left = r;
        } else {
            p.parent.right = r;
        }
        r.left = p;
        p.parent = r;
    }

    private void rotateRight(Entry p) {
        Entry l = p.left;
        p.left = l.right;
        if (l.right != null) {
            l.right.parent = p;
        }
        l.parent = p.parent;
        if (p.parent == null) {
            this.root = l;
        } else if (p.parent.right == p) {
            p.parent.right = l;
        } else {
            p.parent.left = l;
        }
        l.right = p;
        p.parent = l;
    }

    private void fixAfterInsertion(Entry x) {
        x.color = false;
        while (x != null && x != this.root && !x.parent.color) {
            Entry y;
            if (RedBlackMap.parentOf(x) == RedBlackMap.leftOf(RedBlackMap.parentOf(RedBlackMap.parentOf(x)))) {
                y = RedBlackMap.rightOf(RedBlackMap.parentOf(RedBlackMap.parentOf(x)));
                if (!RedBlackMap.colorOf(y)) {
                    RedBlackMap.setColor(RedBlackMap.parentOf(x), true);
                    RedBlackMap.setColor(y, true);
                    RedBlackMap.setColor(RedBlackMap.parentOf(RedBlackMap.parentOf(x)), false);
                    x = RedBlackMap.parentOf(RedBlackMap.parentOf(x));
                    continue;
                }
                if (x == RedBlackMap.rightOf(RedBlackMap.parentOf(x))) {
                    x = RedBlackMap.parentOf(x);
                    this.rotateLeft(x);
                }
                RedBlackMap.setColor(RedBlackMap.parentOf(x), true);
                RedBlackMap.setColor(RedBlackMap.parentOf(RedBlackMap.parentOf(x)), false);
                if (RedBlackMap.parentOf(RedBlackMap.parentOf(x)) == null) continue;
                this.rotateRight(RedBlackMap.parentOf(RedBlackMap.parentOf(x)));
                continue;
            }
            y = RedBlackMap.leftOf(RedBlackMap.parentOf(RedBlackMap.parentOf(x)));
            if (!RedBlackMap.colorOf(y)) {
                RedBlackMap.setColor(RedBlackMap.parentOf(x), true);
                RedBlackMap.setColor(y, true);
                RedBlackMap.setColor(RedBlackMap.parentOf(RedBlackMap.parentOf(x)), false);
                x = RedBlackMap.parentOf(RedBlackMap.parentOf(x));
                continue;
            }
            if (x == RedBlackMap.leftOf(RedBlackMap.parentOf(x))) {
                x = RedBlackMap.parentOf(x);
                this.rotateRight(x);
            }
            RedBlackMap.setColor(RedBlackMap.parentOf(x), true);
            RedBlackMap.setColor(RedBlackMap.parentOf(RedBlackMap.parentOf(x)), false);
            if (RedBlackMap.parentOf(RedBlackMap.parentOf(x)) == null) continue;
            this.rotateLeft(RedBlackMap.parentOf(RedBlackMap.parentOf(x)));
        }
        this.root.color = true;
    }

    private void deleteEntry(Entry p) {
        Entry replacement;
        this.decrementSize();
        if (p.left != null && p.right != null) {
            Entry s = this.successor(p);
            p.key = s.key;
            p.value = s.value;
            p = s;
        }
        Entry entry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
        p.deleted = true;
    }

    private void fixAfterDeletion(Entry x) {
        while (x != this.root && RedBlackMap.colorOf(x)) {
            Entry sib;
            if (x == RedBlackMap.leftOf(RedBlackMap.parentOf(x))) {
                sib = RedBlackMap.rightOf(RedBlackMap.parentOf(x));
                if (!RedBlackMap.colorOf(sib)) {
                    RedBlackMap.setColor(sib, true);
                    RedBlackMap.setColor(RedBlackMap.parentOf(x), false);
                    this.rotateLeft(RedBlackMap.parentOf(x));
                    sib = RedBlackMap.rightOf(RedBlackMap.parentOf(x));
                }
                if (RedBlackMap.colorOf(RedBlackMap.leftOf(sib)) && RedBlackMap.colorOf(RedBlackMap.rightOf(sib))) {
                    RedBlackMap.setColor(sib, false);
                    x = RedBlackMap.parentOf(x);
                    continue;
                }
                if (RedBlackMap.colorOf(RedBlackMap.rightOf(sib))) {
                    RedBlackMap.setColor(RedBlackMap.leftOf(sib), true);
                    RedBlackMap.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = RedBlackMap.rightOf(RedBlackMap.parentOf(x));
                }
                RedBlackMap.setColor(sib, RedBlackMap.colorOf(RedBlackMap.parentOf(x)));
                RedBlackMap.setColor(RedBlackMap.parentOf(x), true);
                RedBlackMap.setColor(RedBlackMap.rightOf(sib), true);
                this.rotateLeft(RedBlackMap.parentOf(x));
                x = this.root;
                continue;
            }
            sib = RedBlackMap.leftOf(RedBlackMap.parentOf(x));
            if (!RedBlackMap.colorOf(sib)) {
                RedBlackMap.setColor(sib, true);
                RedBlackMap.setColor(RedBlackMap.parentOf(x), false);
                this.rotateRight(RedBlackMap.parentOf(x));
                sib = RedBlackMap.leftOf(RedBlackMap.parentOf(x));
            }
            if (RedBlackMap.colorOf(RedBlackMap.rightOf(sib)) && RedBlackMap.colorOf(RedBlackMap.leftOf(sib))) {
                RedBlackMap.setColor(sib, false);
                x = RedBlackMap.parentOf(x);
                continue;
            }
            if (RedBlackMap.colorOf(RedBlackMap.leftOf(sib))) {
                RedBlackMap.setColor(RedBlackMap.rightOf(sib), true);
                RedBlackMap.setColor(sib, false);
                this.rotateLeft(sib);
                sib = RedBlackMap.leftOf(RedBlackMap.parentOf(x));
            }
            RedBlackMap.setColor(sib, RedBlackMap.colorOf(RedBlackMap.parentOf(x)));
            RedBlackMap.setColor(RedBlackMap.parentOf(x), true);
            RedBlackMap.setColor(RedBlackMap.leftOf(sib), true);
            this.rotateRight(RedBlackMap.parentOf(x));
            x = this.root;
        }
        RedBlackMap.setColor(x, true);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (Entry e : this.entrySet()) {
            s.writeObject(e.key);
            s.writeObject(e.value);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.buildFromSorted(size, null, s, null);
    }

    void readTreeSet(int size, ObjectInputStream s, Object defaultVal) throws IOException, ClassNotFoundException {
        this.buildFromSorted(size, null, s, defaultVal);
    }

    void addAllForTreeSet(SortedSet set, Object defaultVal) {
        try {
            this.buildFromSorted(set.size(), set.iterator(), null, defaultVal);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromSorted(int size, Iterator it, ObjectInputStream str, Object defaultVal) throws IOException, ClassNotFoundException {
        this.size = size;
        this.root = RedBlackMap.buildFromSorted(0, 0, size - 1, RedBlackMap.computeRedLevel(size), it, str, defaultVal);
    }

    private static void setColor(Entry p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static Object key(Entry e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.key;
    }

    private static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static boolean colorOf(Entry p) {
        return p == null ? true : p.color;
    }

    private static Entry parentOf(Entry p) {
        return p == null ? null : p.parent;
    }

    private static Entry leftOf(Entry p) {
        return p == null ? null : p.left;
    }

    private static Entry rightOf(Entry p) {
        return p == null ? null : p.right;
    }

    private static Entry buildFromSorted(int level, int lo, int hi, int redLevel, Iterator it, ObjectInputStream str, Object defaultVal) throws IOException, ClassNotFoundException {
        Object value;
        Object key;
        if (hi < lo) {
            return null;
        }
        int mid = (lo + hi) / 2;
        Entry left = null;
        if (lo < mid) {
            left = RedBlackMap.buildFromSorted(level + 1, lo, mid - 1, redLevel, it, str, defaultVal);
        }
        if (it != null) {
            if (defaultVal == null) {
                Map.Entry entry = (Map.Entry)it.next();
                key = entry.getKey();
                value = entry.getValue();
            } else {
                key = it.next();
                value = defaultVal;
            }
        } else {
            key = str.readObject();
            value = defaultVal != null ? defaultVal : str.readObject();
        }
        Entry middle = new Entry(key, value, null);
        if (level == redLevel) {
            middle.color = false;
        }
        if (left != null) {
            middle.left = left;
            left.parent = middle;
        }
        if (mid < hi) {
            Entry right;
            middle.right = right = RedBlackMap.buildFromSorted(level + 1, mid + 1, hi, redLevel, it, str, defaultVal);
            right.parent = middle;
        }
        return middle;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    static class Entry
    implements Map.Entry {
        Object key;
        Object value;
        Entry left = null;
        Entry right = null;
        Entry parent;
        boolean color = true;
        boolean deleted = false;

        Entry(Object key, Object value, Entry parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return RedBlackMap.valEquals(this.key, e.getKey()) && RedBlackMap.valEquals(this.value, e.getValue());
        }

        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class SubWrappedMapEntryIterator
    implements Iterator {
        SubMapEntryIterator iterator1;
        SubMapEntryIterator iterator2;

        SubWrappedMapEntryIterator(Entry first, Entry firstExcluded) {
            this.iterator1 = new SubMapEntryIterator(RedBlackMap.this.firstEntry(), firstExcluded);
            this.iterator2 = new SubMapEntryIterator(first, null);
        }

        public boolean hasNext() {
            return this.iterator1.hasNext() || this.iterator2.hasNext();
        }

        public Object next() {
            return this.iterator1.hasNext() ? this.iterator1.next() : this.iterator2.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("remove not supported!");
        }
    }

    private class SubMapEntryIterator
    extends EntryIterator {
        private final Object firstExcludedKey;

        SubMapEntryIterator(Entry first, Entry firstExcluded) {
            super(first);
            this.firstExcludedKey = firstExcluded == null ? firstExcluded : firstExcluded.key;
        }

        public boolean hasNext() {
            return this.next != null && (this.firstExcludedKey == null || RedBlackMap.this.compare(this.next.key, this.firstExcludedKey) < 0);
        }

        public Object next() {
            if (this.next == null || this.firstExcludedKey != null && RedBlackMap.this.compare(this.next.key, this.firstExcludedKey) >= 0) {
                throw new NoSuchElementException();
            }
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().key;
        }
    }

    private class EntryIterator
    implements Iterator {
        private Entry lastReturned = null;
        protected Entry next = null;

        EntryIterator() {
            this.next = RedBlackMap.this.firstEntry();
        }

        EntryIterator(Entry first) {
            this.next = first;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        final Entry nextEntry() {
            this.lastReturned = this.next;
            this.next = RedBlackMap.this.successor(this.next);
            return this.lastReturned;
        }

        public Object next() {
            return this.nextEntry();
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove not supported!");
        }
    }

    private class SubWrappedMap
    extends AbstractMap
    implements SortedMap,
    Serializable {
        private Object fromKey;
        private Object toKey;
        private transient Set entrySet = new EntrySetView();
        private static final long serialVersionUID = -6520786458950516097L;

        SubWrappedMap(Object fromKey, Object toKey) {
            if (RedBlackMap.this.compare(fromKey, toKey) < 0) {
                throw new IllegalArgumentException("fromKey < toKey");
            }
            this.fromKey = fromKey;
            this.toKey = toKey;
        }

        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        public Object get(Object key) {
            if (!this.inRange(key)) {
                return null;
            }
            return RedBlackMap.this.get(key);
        }

        public boolean containsKey(Object key) {
            return this.inRange(key) && RedBlackMap.this.containsKey(key);
        }

        public Object put(Object key, Object value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return RedBlackMap.this.put(key, value);
        }

        public Comparator comparator() {
            return RedBlackMap.this.comparator;
        }

        public Object firstKey() {
            if (RedBlackMap.this.compare(RedBlackMap.key(RedBlackMap.this.firstEntry()), this.toKey) < 0) {
                return RedBlackMap.key(RedBlackMap.this.firstEntry());
            }
            if (RedBlackMap.this.getCeilEntry(this.fromKey) == null) {
                throw new NoSuchElementException();
            }
            return RedBlackMap.key(RedBlackMap.this.getCeilEntry(this.fromKey));
        }

        public Object lastKey() {
            if (RedBlackMap.this.compare(RedBlackMap.key(RedBlackMap.this.lastEntry()), this.fromKey) > 0) {
                return RedBlackMap.key(RedBlackMap.this.lastEntry());
            }
            if (RedBlackMap.this.getPrecedingEntry(this.toKey) == null) {
                throw new NoSuchElementException();
            }
            return RedBlackMap.key(RedBlackMap.this.getPrecedingEntry(this.toKey));
        }

        public Set entrySet() {
            return this.entrySet;
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            if (RedBlackMap.this.compare(fromKey, toKey) > 0) {
                if (RedBlackMap.this.compare(fromKey, this.toKey) < 0 && RedBlackMap.this.compare(toKey, this.fromKey) > 0) {
                    fromKey = RedBlackMap.this.compare(fromKey, this.fromKey) < 0 ? this.fromKey : fromKey;
                    toKey = RedBlackMap.this.compare(toKey, this.toKey) > 0 ? this.toKey : toKey;
                    return new SubWrappedMap(fromKey, toKey);
                }
                return new RedBlackMap(this).subMap(fromKey, toKey);
            }
            if (RedBlackMap.this.compare(fromKey, this.toKey) < 0 && RedBlackMap.this.compare(toKey, this.fromKey) > 0) {
                return new RedBlackMap(this).subMap(fromKey, toKey);
            }
            fromKey = RedBlackMap.this.compare(fromKey, this.toKey) > 0 && RedBlackMap.this.compare(fromKey, this.fromKey) < 0 ? this.fromKey : fromKey;
            Object object = toKey = RedBlackMap.this.compare(toKey, this.toKey) > 0 && RedBlackMap.this.compare(toKey, this.fromKey) < 0 ? this.toKey : toKey;
            if (RedBlackMap.this.compare(fromKey, toKey) > 0) {
                return new SubMap(fromKey, fromKey);
            }
            return new SubMap(fromKey, toKey);
        }

        public SortedMap headMap(Object toKey) {
            if (RedBlackMap.this.compare(toKey, this.fromKey) > 0) {
                return new RedBlackMap(this).headMap(toKey);
            }
            if (RedBlackMap.this.compare(toKey, this.toKey) > 0) {
                return RedBlackMap.this.headMap(this.toKey);
            }
            return RedBlackMap.this.headMap(toKey);
        }

        public SortedMap tailMap(Object fromKey) {
            if (RedBlackMap.this.compare(fromKey, this.toKey) < 0) {
                return new RedBlackMap(this).tailMap(fromKey);
            }
            if (RedBlackMap.this.compare(fromKey, this.fromKey) < 0) {
                return RedBlackMap.this.tailMap(this.fromKey);
            }
            return RedBlackMap.this.tailMap(fromKey);
        }

        private boolean inRange(Object key) {
            return RedBlackMap.this.compare(key, this.fromKey) >= 0 || RedBlackMap.this.compare(key, this.toKey) < 0;
        }

        private boolean inRange2(Object key) {
            return RedBlackMap.this.compare(key, this.fromKey) >= 0 || RedBlackMap.this.compare(key, this.toKey) <= 0;
        }

        private class EntrySetView
        extends AbstractSet {
            private transient int size = -1;
            private transient int sizeModCount;

            private EntrySetView() {
            }

            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            public int size() {
                if (this.size == -1 || this.sizeModCount != RedBlackMap.this.modCount) {
                    this.size = 0;
                    this.sizeModCount = RedBlackMap.this.modCount;
                    Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                }
                return this.size;
            }

            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!SubWrappedMap.this.inRange(key)) {
                    return false;
                }
                Entry node = RedBlackMap.this.getEntry(key);
                return node != null && RedBlackMap.valEquals(node.getValue(), entry.getValue());
            }

            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!SubWrappedMap.this.inRange(key)) {
                    return false;
                }
                Entry node = RedBlackMap.this.getEntry(key);
                if (node != null && RedBlackMap.valEquals(node.getValue(), entry.getValue())) {
                    RedBlackMap.this.deleteEntry(node);
                    return true;
                }
                return false;
            }

            public Iterator iterator() {
                Entry from = RedBlackMap.this.getCeilEntry(SubWrappedMap.this.fromKey);
                Entry to = RedBlackMap.this.getPrecedingEntry(SubWrappedMap.this.toKey);
                if (from == null) {
                    return new SubMapEntryIterator(RedBlackMap.this.firstEntry(), RedBlackMap.this.getCeilEntry(SubWrappedMap.this.toKey));
                }
                if (to == null) {
                    return new SubWrappedMapEntryIterator(from, RedBlackMap.this.firstEntry());
                }
                return new SubWrappedMapEntryIterator(from, RedBlackMap.this.getCeilEntry(SubWrappedMap.this.toKey));
            }
        }
    }

    private class SubMap
    extends AbstractMap
    implements SortedMap,
    Serializable {
        private boolean fromStart = false;
        private boolean toEnd = false;
        private Object fromKey;
        private Object toKey;
        private transient Set entrySet = new EntrySetView();
        private static final long serialVersionUID = -6520786458950516097L;

        SubMap(Object fromKey, Object toKey) {
            if (RedBlackMap.this.compare(fromKey, toKey) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = fromKey;
            this.toKey = toKey;
        }

        SubMap(Object key, boolean headMap) {
            RedBlackMap.this.compare(key, key);
            if (headMap) {
                this.fromStart = true;
                this.toKey = key;
            } else {
                this.toEnd = true;
                this.fromKey = key;
            }
        }

        SubMap(boolean fromStart, Object fromKey, boolean toEnd, Object toKey) {
            this.fromStart = fromStart;
            this.fromKey = fromKey;
            this.toEnd = toEnd;
            this.toKey = toKey;
        }

        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        public Object get(Object key) {
            if (!this.inRange(key)) {
                return null;
            }
            return RedBlackMap.this.get(key);
        }

        public boolean containsKey(Object key) {
            return this.inRange(key) && RedBlackMap.this.containsKey(key);
        }

        public Object put(Object key, Object value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return RedBlackMap.this.put(key, value);
        }

        public Comparator comparator() {
            return RedBlackMap.this.comparator;
        }

        public Object firstKey() {
            Object first = RedBlackMap.key(this.fromStart ? RedBlackMap.this.firstEntry() : RedBlackMap.this.getCeilEntry(this.fromKey));
            if (!this.toEnd && RedBlackMap.this.compare(first, this.toKey) >= 0) {
                throw new NoSuchElementException();
            }
            return first;
        }

        public Object lastKey() {
            Object last = RedBlackMap.key(this.toEnd ? RedBlackMap.this.lastEntry() : RedBlackMap.this.getPrecedingEntry(this.toKey));
            if (!this.fromStart && RedBlackMap.this.compare(last, this.fromKey) < 0) {
                throw new NoSuchElementException();
            }
            return last;
        }

        public Set entrySet() {
            return this.entrySet;
        }

        protected Object putInRange(Object key) {
            if (!this.fromStart && RedBlackMap.this.compare(key, this.fromKey) < 0) {
                return this.fromKey;
            }
            if (!this.toEnd && RedBlackMap.this.compare(key, this.toKey) > 0) {
                return this.toKey;
            }
            return key;
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            if (RedBlackMap.this.compare(fromKey, toKey) > 0) {
                return new RedBlackMap(this).subMap(fromKey, toKey);
            }
            return new SubMap(this.putInRange(fromKey), this.putInRange(toKey));
        }

        public SortedMap headMap(Object toKey) {
            return new SubMap(this.fromStart, this.fromKey, false, this.putInRange(toKey));
        }

        public SortedMap tailMap(Object fromKey) {
            return new SubMap(false, this.putInRange(fromKey), this.toEnd, this.toKey);
        }

        private boolean inRange(Object key) {
            return !(!this.fromStart && RedBlackMap.this.compare(key, this.fromKey) < 0 || !this.toEnd && RedBlackMap.this.compare(key, this.toKey) >= 0);
        }

        private boolean inRange2(Object key) {
            return !(!this.fromStart && RedBlackMap.this.compare(key, this.fromKey) < 0 || !this.toEnd && RedBlackMap.this.compare(key, this.toKey) > 0);
        }

        private class EntrySetView
        extends AbstractSet {
            private transient int size = -1;
            private transient int sizeModCount;

            private EntrySetView() {
            }

            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            public int size() {
                if (this.size == -1 || this.sizeModCount != RedBlackMap.this.modCount) {
                    this.size = 0;
                    this.sizeModCount = RedBlackMap.this.modCount;
                    Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                }
                return this.size;
            }

            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = RedBlackMap.this.getEntry(key);
                return node != null && RedBlackMap.valEquals(node.getValue(), entry.getValue());
            }

            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = RedBlackMap.this.getEntry(key);
                if (node != null && RedBlackMap.valEquals(node.getValue(), entry.getValue())) {
                    RedBlackMap.this.deleteEntry(node);
                    return true;
                }
                return false;
            }

            public Iterator iterator() {
                return new SubMapEntryIterator(SubMap.this.fromStart ? RedBlackMap.this.firstEntry() : RedBlackMap.this.getCeilEntry(SubMap.this.fromKey), SubMap.this.toEnd ? null : RedBlackMap.this.getCeilEntry(SubMap.this.toKey));
            }
        }
    }
}

