/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.io.Serializable;
import java.util.BitSet;
import rice.environment.random.simple.SimpleRandomSource;
import rice.p2p.util.MathUtils;

public class BloomFilter
implements Serializable {
    protected int[] parameters;
    protected int length;
    protected BitSet set;
    public static int PARAMETER_LENGTH = 4;

    public BloomFilter(int num, int length) {
        SimpleRandomSource rand = new SimpleRandomSource(null);
        this.length = length;
        this.set = new BitSet(length);
        this.parameters = new int[num];
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = MathUtils.randomInt(rand);
        }
    }

    public String getBitSet() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[BloomFilter ");
        for (int i = 0; i < this.length; ++i) {
            if (this.set.get(i)) {
                buffer.append("1");
                continue;
            }
            buffer.append("0");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public void add(byte[] array) {
        for (int i = 0; i < this.parameters.length; ++i) {
            this.set.set(this.hash(array, i));
        }
    }

    public boolean check(byte[] array) {
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.set.get(this.hash(array, i))) continue;
            return false;
        }
        return true;
    }

    protected int hash(byte[] array, int i) {
        if (this.length <= 0) {
            return 0;
        }
        return MathUtils.mod(this.doHash(array, this.parameters[i]), this.length);
    }

    protected int doHash(byte[] array, int seed) {
        int result = 0;
        byte[] tmp = new byte[4];
        for (int i = 0; i < array.length; i += 4) {
            System.arraycopy(array, i, tmp, 0, array.length - i < 4 ? array.length - i : 4);
            result += result * seed + MathUtils.byteArrayToInt(tmp);
        }
        return result;
    }
}

