/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.splitstream.testing;

import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.RangeCannotBeDeterminedException;
import rice.p2p.splitstream.Channel;
import rice.p2p.splitstream.ChannelId;
import rice.p2p.splitstream.SplitStream;
import rice.p2p.splitstream.SplitStreamClient;
import rice.p2p.splitstream.SplitStreamImpl;
import rice.p2p.splitstream.SplitStreamScribePolicy;
import rice.p2p.splitstream.Stripe;
import rice.p2p.util.MathUtils;
import rice.pastry.IdRange;
import rice.pastry.PastryNode;
import rice.selector.TimerTask;

public class MySplitStreamClient
implements SplitStreamClient {
    int SEND_PERIOD = 15000;
    int msgSize = 24;
    private PastryNode n = null;
    private Stripe[] stripes;
    private Channel channel;
    private SplitStream ss;
    private int numMesgsReceived = 0;
    private SplitStreamScribePolicy policy = null;
    private String instance;
    TimerTask publishTask;
    int curSeq = 0;

    public MySplitStreamClient(PastryNode n, String instance) {
        this.n = n;
        this.instance = instance;
        this.ss = new SplitStreamImpl(n, instance);
    }

    public Stripe[] getStripes() {
        this.stripes = this.channel.getStripes();
        return this.stripes;
    }

    public void attachChannel(ChannelId cid) {
        System.out.println("Attaching to Channel " + cid + " at " + this.n.getEnvironment().getTimeSource().currentTimeMillis());
        if (this.channel == null) {
            this.channel = this.ss.attachChannel(cid);
        }
        this.getStripes();
    }

    public void subscribeToAllChannels() {
        for (int i = 0; i < this.stripes.length; ++i) {
            this.stripes[i].subscribe(this);
        }
    }

    public boolean shouldPublish() {
        try {
            IdRange range = this.n.getLeafSet().range(this.n.getLocalHandle(), 0);
            return range.containsId(rice.pastry.Id.build());
        }
        catch (RangeCannotBeDeterminedException rcbde) {
            return true;
        }
    }

    public void publishNext() {
        if (this.shouldPublish()) {
            this.publish(this.n.getId(), this.curSeq);
            ++this.curSeq;
        }
    }

    public void publish(Id id, int seq) {
        System.out.println("MSSC.publish(" + id + ":" + seq + "):" + this.n.getEnvironment().getTimeSource().currentTimeMillis());
        byte[] msg = new byte[this.msgSize];
        byte[] head = MathUtils.intToByteArray(seq);
        System.arraycopy(head, 0, msg, 0, 4);
        byte[] idArray = id.toByteArray();
        System.arraycopy(idArray, 0, msg, 4, 20);
        rice.pastry.Id.build(idArray);
        this.publishAll(msg);
    }

    public void publishAll(byte[] b) {
        for (int i = 0; i < this.stripes.length; ++i) {
            this.publish(b, this.stripes[i]);
        }
    }

    public void publish(byte[] b, Stripe s) {
        s.publish(b);
    }

    public void joinFailed(Stripe s) {
        System.out.println("MSSC.joinFailed(" + s + "):" + this.n.getEnvironment().getTimeSource().currentTimeMillis());
    }

    public void deliver(Stripe s, byte[] data) {
        byte[] theInt = new byte[4];
        System.arraycopy(data, 0, theInt, 0, 4);
        int seq = MathUtils.byteArrayToInt(theInt);
        byte[] material = new byte[20];
        System.arraycopy(data, 4, material, 0, 20);
        rice.pastry.Id publisher = rice.pastry.Id.build(material);
        rice.pastry.Id stripeId = (rice.pastry.Id)s.getStripeId().getId();
        String stripeStr = ((Object)stripeId).toString().substring(3, 4);
        System.out.println("deliver(" + stripeStr + "," + publisher + "," + seq + "):" + this.n.getEnvironment().getTimeSource().currentTimeMillis());
    }

    public void startPublishTask() {
        this.publishTask = new TimerTask(){

            public void run() {
                MySplitStreamClient.this.publishNext();
            }
        };
        this.n.getEnvironment().getSelectorManager().getTimer().schedule(this.publishTask, this.SEND_PERIOD, this.SEND_PERIOD);
    }
}

