/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.splitstream;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.scribe.Scribe;
import rice.p2p.scribe.ScribeClient;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.ScribePolicy;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.messaging.AnycastMessage;
import rice.p2p.scribe.messaging.SubscribeMessage;
import rice.p2p.splitstream.Channel;
import rice.p2p.splitstream.ChannelId;
import rice.p2p.splitstream.SplitStream;
import rice.p2p.splitstream.SplitStreamSubscribeContent;
import rice.p2p.splitstream.Stripe;

public class SplitStreamScribePolicy
implements ScribePolicy {
    public final int DEFAULT_MAXIMUM_CHILDREN;
    protected SplitStream splitStream;
    protected Scribe scribe;
    protected Hashtable policy;

    public SplitStreamScribePolicy(Scribe scribe, SplitStream splitStream) {
        this.DEFAULT_MAXIMUM_CHILDREN = scribe.getEnvironment().getParameters().getInt("p2p_splitStream_policy_default_maximum_children");
        this.scribe = scribe;
        this.splitStream = splitStream;
        this.policy = new Hashtable();
    }

    public int getMaxChildren(ChannelId id) {
        Integer max = (Integer)this.policy.get(id);
        if (max == null) {
            return this.DEFAULT_MAXIMUM_CHILDREN;
        }
        return max;
    }

    private Channel getChannel(Topic topic) {
        Channel[] channels = this.splitStream.getChannels();
        for (int i = 0; i < channels.length; ++i) {
            Channel channel = channels[i];
            Stripe[] stripes = channel.getStripes();
            for (int j = 0; j < stripes.length; ++j) {
                Stripe stripe = stripes[j];
                if (!stripe.getStripeId().getId().equals(topic.getId())) continue;
                return channel;
            }
        }
        return null;
    }

    public int getTotalChildren(Channel channel) {
        int total = 0;
        Stripe[] stripes = channel.getStripes();
        for (int j = 0; j < stripes.length; ++j) {
            total += this.scribe.getChildren(new Topic(stripes[j].getStripeId().getId())).length;
        }
        return total;
    }

    public void setMaxChildren(ChannelId id, int children) {
        this.policy.put(id, new Integer(children));
    }

    public boolean allowSubscribe(SubscribeMessage message, ScribeClient[] clients, NodeHandle[] children) {
        int stage;
        Channel channel = this.getChannel(message.getTopic());
        NodeHandle newChild = message.getSubscriber();
        if (channel == null) {
            return this.scribe.isRoot(message.getTopic());
        }
        if (message.getSubscriber().getId().equals(channel.getLocalId())) {
            return false;
        }
        ScribeContent content = message.getContent();
        if (content != null && content instanceof SplitStreamSubscribeContent && (stage = ((SplitStreamSubscribeContent)content).getStage()) == SplitStreamSubscribeContent.STAGE_FINAL) {
            List<NodeHandle> list = Arrays.asList(children);
            if (!list.contains(message.getSource())) {
                return false;
            }
            this.scribe.removeChild(message.getTopic(), message.getSource());
            return true;
        }
        if (this.getTotalChildren(channel) < this.getMaxChildren(channel.getChannelId())) {
            return true;
        }
        if (!message.getTopic().getId().equals(channel.getPrimaryStripe().getStripeId().getId()) && !this.scribe.isRoot(message.getTopic())) {
            return false;
        }
        if (children.length > 0) {
            NodeHandle victimChild = this.freeBandwidth(channel, newChild, message.getTopic().getId());
            if (victimChild.getId().equals(newChild.getId())) {
                return false;
            }
            this.scribe.removeChild(new Topic(message.getTopic().getId()), victimChild);
            return true;
        }
        Vector res = this.freeBandwidthUltimate(message.getTopic().getId());
        if (res != null) {
            this.scribe.removeChild(new Topic((Id)res.elementAt(1)), (NodeHandle)res.elementAt(0));
            return true;
        }
        return false;
    }

    public void directAnycast(AnycastMessage message, NodeHandle parent, NodeHandle[] children) {
        if (parent != null) {
            if (SplitStreamScribePolicy.getPrefixMatch(message.getTopic().getId(), parent.getId(), this.splitStream.getStripeBaseBitLength()) > 0) {
                message.addFirst(parent);
            } else {
                message.addLast(parent);
            }
        }
        if (message instanceof SubscribeMessage) {
            int index;
            Vector<NodeHandle> good = new Vector<NodeHandle>();
            Vector<NodeHandle> bad = new Vector<NodeHandle>();
            for (int i = 0; i < children.length; ++i) {
                if (SplitStreamScribePolicy.getPrefixMatch(message.getTopic().getId(), children[i].getId(), this.splitStream.getStripeBaseBitLength()) > 0) {
                    good.add(children[i]);
                    continue;
                }
                bad.add(children[i]);
            }
            while (good.size() > 0) {
                index = this.scribe.getEnvironment().getRandomSource().nextInt(good.size());
                message.addFirst((NodeHandle)good.elementAt(index));
                good.remove((NodeHandle)good.elementAt(index));
            }
            while (bad.size() > 0) {
                index = this.scribe.getEnvironment().getRandomSource().nextInt(bad.size());
                message.addLast((NodeHandle)bad.elementAt(index));
                bad.remove((NodeHandle)bad.elementAt(index));
            }
            NodeHandle nextHop = message.getNext();
            while (nextHop != null && !nextHop.isAlive()) {
                nextHop = message.getNext();
            }
            if (nextHop == null) {
                if (this.scribe.isRoot(message.getTopic())) {
                    Vector res = this.freeBandwidthUltimate(message.getTopic().getId());
                    if (res != null) {
                        this.scribe.removeChild(new Topic((Id)res.elementAt(1)), (NodeHandle)res.elementAt(0));
                        this.scribe.addChild(message.getTopic(), ((SubscribeMessage)message).getSubscriber());
                        return;
                    }
                } else {
                    SplitStreamSubscribeContent ssc = new SplitStreamSubscribeContent(SplitStreamSubscribeContent.STAGE_FINAL);
                    message.remove(parent);
                    message.addFirst(parent);
                    message.setContent(ssc);
                }
            } else {
                message.addFirst(nextHop);
            }
        }
    }

    public Vector freeBandwidthUltimate(Id stripeId) {
        Topic tp;
        int i;
        Channel channel = this.getChannel(new Topic(stripeId));
        Stripe[] stripes = channel.getStripes();
        Vector<Id> candidateStripes = new Vector<Id>();
        Id victimStripeId = null;
        for (i = 0; i < stripes.length; ++i) {
            tp = new Topic(stripes[i].getStripeId().getId());
            if (channel.getPrimaryStripe().getStripeId().getId().equals(stripes[i].getStripeId().getId()) || this.scribe.isRoot(tp) || this.scribe.getChildren(tp).length <= 0) continue;
            candidateStripes.add(stripes[i].getStripeId().getId());
        }
        if (candidateStripes.size() == 0) {
            for (i = 0; i < stripes.length; ++i) {
                tp = new Topic(stripes[i].getStripeId().getId());
                if (channel.getPrimaryStripe().getStripeId().getId().equals(stripes[i].getStripeId().getId()) || this.scribe.getChildren(tp).length <= 0 || stripes[i].getStripeId().getId().equals(stripeId)) continue;
                candidateStripes.add(stripes[i].getStripeId().getId());
            }
        }
        if (candidateStripes.size() > 0) {
            victimStripeId = (Id)candidateStripes.elementAt(this.scribe.getEnvironment().getRandomSource().nextInt(candidateStripes.size()));
            NodeHandle[] children = this.scribe.getChildren(new Topic(victimStripeId));
            NodeHandle child = children[this.scribe.getEnvironment().getRandomSource().nextInt(children.length)];
            Vector<Serializable> result = new Vector<Serializable>();
            result.addElement(child);
            result.addElement(victimStripeId);
            return result;
        }
        return null;
    }

    public NodeHandle freeBandwidth(Channel channel, NodeHandle newChild, Id stripeId) {
        Stripe primaryStripe = channel.getPrimaryStripe();
        Id localId = channel.getLocalId();
        NodeHandle[] children = this.scribe.getChildren(new Topic(primaryStripe.getStripeId().getId()));
        int minPrefixMatch = SplitStreamScribePolicy.getPrefixMatch(stripeId, newChild.getId(), channel.getStripeBase());
        Vector<NodeHandle> victims = new Vector<NodeHandle>();
        for (int j = 0; j < children.length; ++j) {
            NodeHandle c = children[j];
            int match = SplitStreamScribePolicy.getPrefixMatch(stripeId, c.getId(), channel.getStripeBase());
            if (match >= minPrefixMatch) continue;
            victims.addElement(c);
        }
        if (victims.size() == 0) {
            return newChild;
        }
        return (NodeHandle)victims.elementAt(this.scribe.getEnvironment().getRandomSource().nextInt(victims.size()));
    }

    public void childAdded(Topic topic, NodeHandle child) {
    }

    public void childRemoved(Topic topic, NodeHandle child) {
    }

    public static int getPrefixMatch(Id target, Id sample, int digitLength) {
        int numDigits = 160 / digitLength - 1;
        return numDigits - ((rice.pastry.Id)target).indexOfMSDD((rice.pastry.Id)sample, digitLength);
    }
}

