/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.testing;

import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import rice.environment.Environment;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.testing.CommonAPITest;
import rice.p2p.scribe.Scribe;
import rice.p2p.scribe.ScribeClient;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.ScribeImpl;
import rice.p2p.scribe.ScribePolicy;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.messaging.SubscribeMessage;

public class ScribeRegrTest
extends CommonAPITest {
    protected ScribeImpl[] scribes;
    protected TestScribePolicy[] policies;
    public static String INSTANCE = "ScribeRegrTest";

    public ScribeRegrTest(Environment env) throws IOException {
        super(env);
        this.scribes = new ScribeImpl[this.NUM_NODES];
        this.policies = new TestScribePolicy[this.NUM_NODES];
    }

    protected void processNode(int num, Node node) {
        this.scribes[num] = new ScribeImpl(node, INSTANCE);
        this.policies[num] = new TestScribePolicy(this.scribes[num]);
        this.scribes[num].setPolicy(this.policies[num]);
    }

    protected void runTest() {
        if (this.NUM_NODES < 2) {
            System.out.println("The DistScribeRegrTest must be run with at least 2 nodes for proper testing.  Use the '-nodes n' to specify the number of nodes.");
            return;
        }
        this.testBasic(1, "Basic");
        this.testBasic(2, "Partial (1)");
        this.testBasic(4, "Partial (2)");
        this.testSingleRoot("Single rooted Trees");
        this.testAPI();
        this.testFailureNotification();
        this.testMaintenance();
    }

    protected void testBasic(int skip, String name) {
        int i;
        int i2;
        int i3;
        this.sectionStart(name + " Scribe Networks");
        int NUM_MESSAGES = 5;
        int SKIP = skip;
        Topic topic = new Topic(this.generateId());
        TestScribeClient[] clients = new TestScribeClient[this.NUM_NODES / SKIP];
        this.stepStart(name + " Tree Construction");
        for (int i4 = 0; i4 < this.NUM_NODES / SKIP; ++i4) {
            clients[i4] = new TestScribeClient(this.scribes[i4], topic, i4);
            this.scribes[i4].subscribe(topic, clients[i4]);
            this.simulate();
        }
        int numWithParent = 0;
        for (int i5 = 0; i5 < this.NUM_NODES / SKIP; ++i5) {
            if (this.scribes[i5].getParent(topic) == null) continue;
            ++numWithParent;
        }
        if (numWithParent < this.NUM_NODES / SKIP - 1) {
            this.stepDone("FAILURE", "Expected at least " + (this.NUM_NODES / SKIP - 1) + " nodes with parents, found " + numWithParent);
        } else {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Publish");
        ScribeImpl local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES / SKIP)];
        for (int i6 = 0; i6 < NUM_MESSAGES; ++i6) {
            local.publish(topic, new TestScribeContent(topic, i6));
            this.simulate();
        }
        boolean failed = false;
        for (i3 = 0; i3 < this.NUM_NODES / SKIP; ++i3) {
            if (clients[i3].getPublishMessages().length == NUM_MESSAGES) continue;
            this.stepDone("FAILURE", "Expected client " + clients[i3] + " to receive all messages, received " + clients[i3].getPublishMessages().length);
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Anycast - No Accept");
        local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        local.anycast(topic, new TestScribeContent(topic, 59));
        this.simulate();
        failed = false;
        for (i3 = 0; i3 < this.NUM_NODES / SKIP; ++i3) {
            if (clients[i3].getAnycastMessages().length == 0) continue;
            this.stepDone("FAILURE", "Expected no accepters for anycast, found one at " + this.scribes[i3]);
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Anycast - 1 Accept");
        TestScribeClient client = clients[this.environment.getRandomSource().nextInt(this.NUM_NODES / SKIP)];
        client.acceptAnycast(true);
        local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        local.anycast(topic, new TestScribeContent(topic, 59));
        this.simulate();
        failed = false;
        for (i2 = 0; i2 < this.NUM_NODES / SKIP; ++i2) {
            if (clients[i2].equals(client)) {
                if (clients[i2].getAnycastMessages().length == 1) continue;
                this.stepDone("FAILURE", "Expected node to accept anycast at " + client + " accepted " + clients[i2].getAnycastMessages().length);
                failed = true;
                continue;
            }
            if (clients[i2].getAnycastMessages().length == 0) continue;
            this.stepDone("FAILURE", "Expected no accepters for anycast, found one at " + this.scribes[i2]);
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Anycast - All Accept");
        for (i2 = 0; i2 < this.NUM_NODES / SKIP; ++i2) {
            clients[i2].acceptAnycast(true);
        }
        local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES / SKIP)];
        local.anycast(topic, new TestScribeContent(topic, 59));
        this.simulate();
        int total = 0;
        for (i = 0; i < this.NUM_NODES / SKIP; ++i) {
            total += clients[i].getAnycastMessages().length;
        }
        if (total != 2) {
            this.stepDone("FAILURE", "Expected 2 anycast messages to be found, found " + total);
        } else {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Unsubscribe");
        for (i = 0; i < this.NUM_NODES / SKIP; ++i) {
            this.scribes[i].unsubscribe(topic, clients[i]);
            this.simulate();
        }
        local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        local.publish(topic, new TestScribeContent(topic, 100));
        this.simulate();
        failed = false;
        for (i = 0; i < this.NUM_NODES / SKIP; ++i) {
            if (clients[i].getPublishMessages().length == NUM_MESSAGES) continue;
            this.stepDone("FAILURE", "Expected client " + clients[i] + " to receive no additional messages, received " + clients[i].getPublishMessages().length);
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Tree Completely Demolished");
        failed = false;
        for (i = 0; i < this.NUM_NODES; ++i) {
            if (this.scribes[i].getClients(topic).length > 0) {
                this.stepDone("FAILURE", "Expected scribe " + this.scribes[i] + " to have no clients, had " + this.scribes[i].getClients(topic).length);
                failed = true;
            }
            if (this.scribes[i].getChildren(topic).length > 0) {
                this.stepDone("FAILURE", "Expected scribe " + this.scribes[i] + " to have no children, had " + this.scribes[i].getChildren(topic).length);
                failed = true;
            }
            if (this.scribes[i].getParent(topic) == null) continue;
            this.stepDone("FAILURE", "Expected scribe " + this.scribes[i] + " to have no parent, had " + this.scribes[i].getParent(topic));
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.sectionDone();
    }

    protected void testAPI() {
        int i;
        int i2;
        this.sectionStart("Scribe API Functionality");
        int NUM_MESSAGES = 5;
        Topic topic = new Topic(this.generateId());
        TestScribeClient[] clients = new TestScribeClient[this.NUM_NODES];
        this.stepStart("Tree Construction");
        for (i2 = 0; i2 < this.NUM_NODES; ++i2) {
            this.policies[i2].allowSubscribe(false);
        }
        for (i2 = 0; i2 < this.NUM_NODES / 2; ++i2) {
            clients[i2] = new TestScribeClient(this.scribes[i2], topic, i2);
            this.scribes[i2].subscribe(topic, clients[i2]);
            this.simulate();
        }
        int numWithParent = 0;
        for (int i3 = 0; i3 < this.NUM_NODES; ++i3) {
            if (this.scribes[i3].getParent(topic) == null) continue;
            ++numWithParent;
        }
        if (numWithParent < this.NUM_NODES / 2 - 1) {
            this.stepDone("FAILURE", "Expected at least " + (this.NUM_NODES / 2 - 1) + " nodes with parents, found " + numWithParent);
        } else if (numWithParent > this.NUM_NODES / 2) {
            this.stepDone("FAILURE", "Expected no more than " + this.NUM_NODES / 2 + " nodes with parents, due to policy, found " + numWithParent);
        } else {
            this.stepDone("SUCCESS");
        }
        this.stepStart("Drop Child");
        ScribeImpl scribe = null;
        TestScribeClient client = null;
        TestScribePolicy policy = null;
        for (i = 0; i < this.NUM_NODES && scribe == null; ++i) {
            if (this.scribes[i].getChildren(topic).length <= 0) continue;
            scribe = this.scribes[i];
            client = clients[i];
            policy = this.policies[i];
        }
        if (scribe == null) {
            this.stepDone("FAILURE", "Could not find any scribes with children");
        } else {
            NodeHandle child = scribe.getChildren(topic)[0];
            policy.neverAllowSubscribe(true);
            scribe.removeChild(topic, child);
            this.simulate();
            ScribeImpl local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
            for (int i4 = 0; i4 < NUM_MESSAGES; ++i4) {
                local.publish(topic, new TestScribeContent(topic, i4));
                this.simulate();
            }
            boolean failed = false;
            for (int i5 = 0; i5 < this.NUM_NODES / 2; ++i5) {
                if (clients[i5].getPublishMessages().length == NUM_MESSAGES) continue;
                this.stepDone("FAILURE", "Expected client " + clients[i5] + " to receive all messages, received " + clients[i5].getPublishMessages().length);
                failed = true;
            }
            NodeHandle[] children = scribe.getChildren(topic);
            if (Arrays.asList(children).contains(child)) {
                this.stepDone("FAILURE", "Child resubscribed to previous node, policy should prevent this.");
                failed = true;
            }
            if (!failed) {
                this.stepDone("SUCCESS");
            }
        }
        this.stepStart("Reset Policies");
        for (i = 0; i < this.NUM_NODES; ++i) {
            this.policies[i].allowSubscribe(true);
            this.policies[i].neverAllowSubscribe(false);
        }
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    protected void testFailureNotification() {
        int i;
        this.sectionStart("Subscribe Failure Notification");
        Topic topic = new Topic(this.generateId());
        this.stepStart("Policy Change");
        for (i = 0; i < this.NUM_NODES; ++i) {
            this.policies[i].neverAllowSubscribe(true);
        }
        this.stepDone("SUCCESS");
        this.stepStart("Subscribe Attempt");
        i = this.environment.getRandomSource().nextInt(this.NUM_NODES);
        while (this.scribes[i].isRoot(topic)) {
            i = this.environment.getRandomSource().nextInt(this.NUM_NODES);
        }
        TestScribeClient client = new TestScribeClient(this.scribes[i], topic, i);
        this.scribes[i].subscribe(topic, client);
        this.simulate();
        this.stepDone("SUCCESS");
        this.stepStart("Failure Notification Delivered");
        if (!client.getSubscribeFailed()) {
            this.stepDone("FAILURE", "Expected subscribe to fail, but did not.");
        } else {
            this.stepDone("SUCCESS");
        }
        this.stepStart("Policy Reset");
        for (int j = 0; j < this.NUM_NODES; ++j) {
            this.policies[j].neverAllowSubscribe(false);
        }
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    protected void testSingleRoot(String name) {
        this.sectionStart(name + "");
        int numTrees = 10;
        boolean failed = false;
        for (int num = 0; num < numTrees; ++num) {
            Topic topic = new Topic(this.generateId());
            TestScribeClient[] clients = new TestScribeClient[this.NUM_NODES];
            this.stepStart(name + " TopicId=" + topic.getId());
            for (int i = 0; i < this.NUM_NODES; ++i) {
                clients[i] = new TestScribeClient(this.scribes[i], topic, i);
                this.scribes[i].subscribe(topic, clients[i]);
                this.simulate();
            }
            int numRoot = 0;
            for (int i = 0; i < this.NUM_NODES; ++i) {
                if (!this.scribes[i].isRoot(topic)) continue;
                ++numRoot;
            }
            if (numRoot != 1) {
                this.stepDone("FAILURE", "Number of roots= " + numRoot);
                failed = true;
                continue;
            }
            this.stepDone("SUCCESS");
        }
        this.sectionDone();
    }

    protected void testMaintenance() {
        int i;
        this.sectionStart("Tree Maintenance Under Node Death");
        int NUM_MESSAGES = 5;
        Topic topic = new Topic(this.generateId());
        TestScribeClient[] clients = new TestScribeClient[this.NUM_NODES];
        this.stepStart("Tree Construction");
        for (int i2 = 0; i2 < this.NUM_NODES; ++i2) {
            clients[i2] = new TestScribeClient(this.scribes[i2], topic, i2);
            this.scribes[i2].subscribe(topic, clients[i2]);
            this.simulate();
        }
        int numWithParent = 0;
        for (i = 0; i < this.NUM_NODES; ++i) {
            if (this.scribes[i].getParent(topic) == null) continue;
            ++numWithParent;
        }
        if (numWithParent < this.NUM_NODES - 1) {
            this.stepDone("FAILURE", "Expected at least " + (this.NUM_NODES - 1) + " nodes with parents, found " + numWithParent);
        } else {
            this.stepDone("SUCCESS");
        }
        this.stepStart("Killing Nodes");
        for (i = 0; i < this.NUM_NODES / 2; ++i) {
            this.scribes[i].destroy();
            this.kill(i);
            this.simulate();
        }
        this.stepDone("SUCCESS");
        this.stepStart("Tree Recovery");
        ScribeImpl local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES / 2) + this.NUM_NODES / 2];
        for (int i3 = 0; i3 < NUM_MESSAGES; ++i3) {
            local.publish(topic, new TestScribeContent(topic, i3));
            this.simulate();
        }
        boolean failed = false;
        for (int i4 = this.NUM_NODES / 2; i4 < this.NUM_NODES; ++i4) {
            if (clients[i4].getPublishMessages().length == NUM_MESSAGES) continue;
            this.stepDone("FAILURE", "Expected client " + clients[i4] + " to receive all messages, received " + clients[i4].getPublishMessages().length);
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.sectionDone();
    }

    private Id generateId() {
        byte[] data = new byte[20];
        this.environment.getRandomSource().nextBytes(data);
        return this.FACTORY.buildId(data);
    }

    public static void main(String[] args) throws IOException {
        Environment env = ScribeRegrTest.parseArgs(args);
        ScribeRegrTest scribeTest = new ScribeRegrTest(env);
        scribeTest.start();
        env.destroy();
    }

    protected static class TestRouteMessage
    implements RouteMessage {
        private Id id;
        private NodeHandle nextHop;
        private Message message;

        public TestRouteMessage(Id id, NodeHandle nextHop, Message message) {
            this.id = id;
            this.nextHop = nextHop;
            this.message = message;
        }

        public Id getDestinationId() {
            return this.id;
        }

        public NodeHandle getNextHopHandle() {
            return this.nextHop;
        }

        public Message getMessage() {
            return this.message;
        }

        public void setDestinationId(Id id) {
            this.id = id;
        }

        public void setNextHopHandle(NodeHandle nextHop) {
            this.nextHop = nextHop;
        }

        public void setMessage(Message message) {
            this.message = message;
        }
    }

    protected static class TestScribeContent
    implements ScribeContent {
        protected Topic topic;
        protected int num;

        public TestScribeContent(Topic topic, int num) {
            this.topic = topic;
            this.num = num;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TestScribeContent)) {
                return false;
            }
            return ((TestScribeContent)o).topic.equals(this.topic) && ((TestScribeContent)o).num == this.num;
        }

        public String toString() {
            return "TestScribeContent(" + this.topic + ", " + this.num + ")";
        }
    }

    public class TestScribePolicy
    extends ScribePolicy.DefaultScribePolicy {
        protected Scribe scribe;
        protected boolean allowSubscribe;
        protected boolean neverAllowSubscribe;

        public TestScribePolicy(Scribe scribe) {
            super(scribe.getEnvironment());
            this.scribe = scribe;
            this.allowSubscribe = true;
            this.neverAllowSubscribe = false;
        }

        public void allowSubscribe(boolean allowSubscribe) {
            this.allowSubscribe = allowSubscribe;
        }

        public void neverAllowSubscribe(boolean neverAllowSubscribe) {
            this.neverAllowSubscribe = neverAllowSubscribe;
        }

        public boolean allowSubscribe(SubscribeMessage message, ScribeClient[] clients, NodeHandle[] children) {
            return !this.neverAllowSubscribe && (this.allowSubscribe || clients.length > 0 || this.scribe.isRoot(message.getTopic()));
        }
    }

    protected class TestScribeClient
    implements ScribeClient {
        protected ScribeImpl scribe;
        protected int i;
        protected Vector publishMessages;
        protected Vector anycastMessages;
        protected Topic topic;
        protected boolean acceptAnycast;
        protected boolean subscribeFailed;

        public TestScribeClient(ScribeImpl scribe, Topic topic, int i) {
            this.scribe = scribe;
            this.i = i;
            this.topic = topic;
            this.publishMessages = new Vector();
            this.anycastMessages = new Vector();
            this.acceptAnycast = false;
            this.subscribeFailed = false;
        }

        public ScribeContent[] getPublishMessages() {
            return this.publishMessages.toArray(new ScribeContent[0]);
        }

        public ScribeContent[] getAnycastMessages() {
            return this.anycastMessages.toArray(new ScribeContent[0]);
        }

        public boolean getSubscribeFailed() {
            return this.subscribeFailed;
        }

        public void acceptAnycast(boolean value) {
            this.acceptAnycast = value;
        }

        public boolean anycast(Topic topic, ScribeContent content) {
            if (this.acceptAnycast) {
                this.anycastMessages.add(content);
            }
            return this.acceptAnycast;
        }

        public void deliver(Topic topic, ScribeContent content) {
            this.publishMessages.add(content);
        }

        public void childAdded(Topic topic, NodeHandle child) {
        }

        public void childRemoved(Topic topic, NodeHandle child) {
        }

        public void subscribeFailed(Topic topic) {
            this.subscribeFailed = true;
        }
    }
}

