/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.messaging;

import java.util.LinkedList;
import java.util.Vector;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.messaging.ScribeMessage;

public class AnycastMessage
extends ScribeMessage {
    protected ScribeContent content;
    protected Vector visited;
    protected LinkedList toVisit;

    public AnycastMessage(NodeHandle source, Topic topic, ScribeContent content) {
        super(source, topic);
        this.content = content;
        this.visited = new Vector();
        this.toVisit = new LinkedList();
        this.addVisited(source);
    }

    public ScribeContent getContent() {
        return this.content;
    }

    public NodeHandle getNext() {
        if (this.toVisit.size() == 0) {
            return null;
        }
        return (NodeHandle)this.toVisit.removeFirst();
    }

    public void setContent(ScribeContent content) {
        this.content = content;
    }

    public NodeHandle peekNext() {
        if (this.toVisit.size() == 0) {
            return null;
        }
        return (NodeHandle)this.toVisit.getFirst();
    }

    public void addVisited(NodeHandle handle) {
        if (handle == null) {
            return;
        }
        if (!this.visited.contains(handle)) {
            this.visited.add(handle);
        }
        while (this.toVisit.remove(handle)) {
            this.toVisit.remove(handle);
        }
    }

    public void addFirst(NodeHandle handle) {
        if (handle == null) {
            return;
        }
        if (!this.toVisit.contains(handle) && !this.visited.contains(handle)) {
            this.toVisit.addFirst(handle);
        }
    }

    public void addLast(NodeHandle handle) {
        if (handle == null) {
            return;
        }
        if (!this.toVisit.contains(handle) && !this.visited.contains(handle)) {
            this.toVisit.addLast(handle);
        }
    }

    public void remove(NodeHandle handle) {
        if (handle == null) {
            return;
        }
        this.toVisit.remove(handle);
        this.visited.remove(handle);
    }
}

