/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import rice.Destructable;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.scribe.Scribe;
import rice.p2p.scribe.ScribeClient;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.ScribePolicy;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.messaging.AnycastMessage;
import rice.p2p.scribe.messaging.DropMessage;
import rice.p2p.scribe.messaging.MaintenanceMessage;
import rice.p2p.scribe.messaging.PublishMessage;
import rice.p2p.scribe.messaging.PublishRequestMessage;
import rice.p2p.scribe.messaging.SubscribeAckMessage;
import rice.p2p.scribe.messaging.SubscribeFailedMessage;
import rice.p2p.scribe.messaging.SubscribeLostMessage;
import rice.p2p.scribe.messaging.SubscribeMessage;
import rice.p2p.scribe.messaging.UnsubscribeMessage;

public class ScribeImpl
implements Scribe,
Application {
    public final int MAINTENANCE_INTERVAL;
    public final int MESSAGE_TIMEOUT;
    public Hashtable topics;
    protected ScribePolicy policy;
    protected Endpoint endpoint;
    protected NodeHandle handle;
    private Hashtable outstanding;
    private Hashtable lost;
    private int id;
    Environment environment;
    Logger logger;
    private String instance;

    public ScribeImpl(Node node, String instance) {
        this(node, new ScribePolicy.DefaultScribePolicy(node.getEnvironment()), instance);
    }

    public ScribeImpl(Node node, ScribePolicy policy, String instance) {
        this.environment = node.getEnvironment();
        this.logger = this.environment.getLogManager().getLogger(ScribeImpl.class, instance);
        Parameters p = this.environment.getParameters();
        this.MAINTENANCE_INTERVAL = p.getInt("p2p_scribe_maintenance_interval");
        this.MESSAGE_TIMEOUT = p.getInt("p2p_scribe_message_timeout");
        this.instance = instance;
        this.endpoint = node.registerApplication((Application)this, instance);
        this.topics = new Hashtable();
        this.outstanding = new Hashtable();
        this.lost = new Hashtable();
        this.policy = policy;
        this.handle = this.endpoint.getLocalNodeHandle();
        this.id = Integer.MIN_VALUE;
        this.endpoint.scheduleMessage(new MaintenanceMessage(), this.environment.getRandomSource().nextInt(this.MAINTENANCE_INTERVAL), this.MAINTENANCE_INTERVAL);
        if (this.logger.level <= 400) {
            this.logger.log(this.endpoint.getId() + ": Starting up Scribe");
        }
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public ScribePolicy getPolicy() {
        return this.policy;
    }

    public Id getId() {
        return this.endpoint.getId();
    }

    public ScribeClient[] getClients(Topic topic) {
        if (this.topics.get(topic) != null) {
            return ((TopicManager)this.topics.get(topic)).getClients();
        }
        return new ScribeClient[0];
    }

    public NodeHandle[] getChildren(Topic topic) {
        if (this.topics.get(topic) != null) {
            return ((TopicManager)this.topics.get(topic)).getChildren();
        }
        return new NodeHandle[0];
    }

    public NodeHandle getParent(Topic topic) {
        if (this.topics.get(topic) != null) {
            return ((TopicManager)this.topics.get(topic)).getParent();
        }
        return null;
    }

    public boolean isRoot(Topic topic) {
        NodeHandleSet set = this.endpoint.replicaSet(topic.getId(), 1);
        if (set.size() == 0) {
            return false;
        }
        return set.getHandle(0).getId().equals(this.endpoint.getId());
    }

    public Topic[] getTopics(ScribeClient client) {
        Vector<Topic> result = new Vector<Topic>();
        Enumeration e = this.topics.keys();
        while (e.hasMoreElements()) {
            Topic topic = (Topic)e.nextElement();
            if (!((TopicManager)this.topics.get(topic)).containsClient(client)) continue;
            result.add(topic);
        }
        return result.toArray(new Topic[0]);
    }

    public void setPolicy(ScribePolicy policy) {
        this.policy = policy;
    }

    private void sendSubscribe(Topic topic, ScribeClient client, ScribeContent content) {
        this.sendSubscribe(topic, client, content, null);
    }

    private void sendSubscribe(Topic topic, ScribeClient client, ScribeContent content, Id previousParent) {
        ScribeClient[] clients;
        ++this.id;
        if (this.logger.level <= 300) {
            this.logger.log(this.endpoint.getId() + ": Sending subscribe message for topic " + topic + " client:" + client);
        }
        if (client == null && (clients = this.getClients(topic)).length > 0) {
            client = clients[0];
        }
        if (client != null) {
            this.outstanding.put(new Integer(this.id), client);
        }
        this.endpoint.route(topic.getId(), new SubscribeMessage(this.handle, topic, previousParent, this.id, content), null);
        CancellableTask task = this.endpoint.scheduleMessage(new SubscribeLostMessage(this.handle, topic, this.id), this.MESSAGE_TIMEOUT);
        this.lost.put(new Integer(this.id), task);
    }

    private void ackMessageReceived(SubscribeAckMessage message) {
        CancellableTask task;
        ScribeClient client = (ScribeClient)this.outstanding.remove(new Integer(message.getId()));
        if (this.logger.level <= 400) {
            this.logger.log(this.endpoint.getId() + ": Removing client " + client + " from list of outstanding for ack " + message.getId());
        }
        if ((task = (CancellableTask)this.lost.remove(new Integer(message.getId()))) != null) {
            task.cancel();
        }
    }

    private void failedMessageReceived(SubscribeFailedMessage message) {
        ScribeClient client = (ScribeClient)this.outstanding.remove(new Integer(message.getId()));
        this.lost.remove(new Integer(message.getId()));
        if (this.logger.level <= 400) {
            this.logger.log(this.endpoint.getId() + ": Telling client " + client + " about FAILURE for outstanding ack " + message.getId());
        }
        if (client != null) {
            client.subscribeFailed(message.getTopic());
        }
    }

    private void lostMessageReceived(SubscribeLostMessage message) {
        ScribeClient client = (ScribeClient)this.outstanding.remove(new Integer(message.getId()));
        this.lost.remove(new Integer(message.getId()));
        if (this.logger.level <= 400) {
            this.logger.log(this.endpoint.getId() + ": Telling client " + client + " about LOSS for outstanding ack " + message.getId());
        }
        if (client != null) {
            client.subscribeFailed(message.getTopic());
        }
    }

    public void subscribe(Topic topic, ScribeClient client) {
        this.subscribe(topic, client, null);
    }

    public void subscribe(Topic topic, ScribeClient client, ScribeContent content) {
        if (this.logger.level <= 400) {
            this.logger.log(this.endpoint.getId() + ": Subscribing client " + client + " to topic " + topic);
        }
        if (this.topics.get(topic) == null) {
            this.topics.put(topic, new TopicManager(topic, client));
            this.sendSubscribe(topic, client, content);
        } else {
            TopicManager manager = (TopicManager)this.topics.get(topic);
            manager.addClient(client);
            if (manager.getParent() == null && !this.isRoot(topic)) {
                this.sendSubscribe(topic, client, content);
            }
        }
    }

    public void unsubscribe(Topic topic, ScribeClient client) {
        if (this.logger.level <= 400) {
            this.logger.log(this.endpoint.getId() + ": Unsubscribing client " + client + " from topic " + topic);
        }
        if (this.topics.get(topic) != null) {
            TopicManager manager = (TopicManager)this.topics.get(topic);
            if (manager.removeClient(client)) {
                this.topics.remove(topic);
                NodeHandle parent = manager.getParent();
                if (parent != null) {
                    this.endpoint.route(null, new UnsubscribeMessage(this.handle, topic), parent);
                }
            }
        } else if (this.logger.level <= 900) {
            this.logger.log(this.endpoint.getId() + ": Attempt to unsubscribe client " + client + " from unknown topic " + topic);
        }
    }

    public void publish(Topic topic, ScribeContent content) {
        if (this.logger.level <= 400) {
            this.logger.log(this.endpoint.getId() + ": Publishing content " + content + " to topic " + topic);
        }
        this.endpoint.route(topic.getId(), new PublishRequestMessage(this.handle, topic, content), null);
    }

    public void anycast(Topic topic, ScribeContent content) {
        if (this.logger.level <= 400) {
            this.logger.log(this.endpoint.getId() + ": Anycasting content " + content + " to topic " + topic);
        }
        this.endpoint.route(topic.getId(), new AnycastMessage(this.handle, topic, content), null);
    }

    public void addChild(Topic topic, NodeHandle child) {
        this.addChild(topic, child, Integer.MAX_VALUE);
    }

    protected void addChild(Topic topic, NodeHandle child, int id) {
        TopicManager manager;
        if (this.logger.level <= 400) {
            this.logger.log(this.endpoint.getId() + ": Adding child " + child + " to topic " + topic);
        }
        if ((manager = (TopicManager)this.topics.get(topic)) == null) {
            manager = new TopicManager(topic, child);
            this.topics.put(topic, manager);
            if (this.logger.level <= 400) {
                this.logger.log(this.endpoint.getId() + ": Implicitly subscribing to topic " + topic);
            }
            this.sendSubscribe(topic, null, null);
        } else {
            manager.addChild(child);
        }
        this.endpoint.route(null, new SubscribeAckMessage(this.handle, topic, manager.getPathToRoot(), id), child);
        this.policy.childAdded(topic, child);
        ScribeClient[] clients = manager.getClients();
        for (int i = 0; i < clients.length; ++i) {
            clients[i].childAdded(topic, child);
        }
    }

    public void removeChild(Topic topic, NodeHandle child) {
        this.removeChild(topic, child, true);
    }

    protected void removeChild(Topic topic, NodeHandle child, boolean sendDrop) {
        if (this.logger.level <= 500) {
            this.logger.log(this.endpoint.getId() + ": Removing child " + child + " from topic " + topic);
        }
        if (this.topics.get(topic) != null) {
            TopicManager manager = (TopicManager)this.topics.get(topic);
            if (manager.removeChild(child)) {
                this.topics.remove(topic);
                NodeHandle parent = manager.getParent();
                if (this.logger.level <= 500) {
                    this.logger.log(this.endpoint.getId() + ": We no longer need topic " + topic + " - unsubscribing from parent " + parent);
                }
                if (parent != null) {
                    this.endpoint.route(null, new UnsubscribeMessage(this.handle, topic), parent);
                }
            }
            if (sendDrop && child.isAlive()) {
                if (this.logger.level <= 500) {
                    this.logger.log(this.endpoint.getId() + ": Informing child " + child + " that he has been dropped from topic " + topic);
                }
                this.endpoint.route(null, new DropMessage(this.handle, topic), child);
            }
            this.policy.childRemoved(topic, child);
            ScribeClient[] clients = manager.getClients();
            for (int i = 0; i < clients.length; ++i) {
                clients[i].childRemoved(topic, child);
            }
        } else if (this.logger.level <= 900) {
            this.logger.log(this.endpoint.getId() + ": Unexpected attempt to remove child " + child + " from unknown topic " + topic);
        }
    }

    public boolean forward(RouteMessage message) {
        if (this.logger.level <= 300) {
            this.logger.log(this.endpoint.getId() + ": Forward called with " + message.getMessage());
        }
        if (message.getMessage() instanceof AnycastMessage) {
            AnycastMessage aMessage = (AnycastMessage)message.getMessage();
            TopicManager manager = (TopicManager)this.topics.get(aMessage.getTopic());
            if (message.getMessage() instanceof SubscribeMessage) {
                SubscribeMessage sMessage = (SubscribeMessage)message.getMessage();
                if (sMessage.getSource().getId().equals(this.endpoint.getId())) {
                    return true;
                }
                if (manager != null) {
                    Id previousParent = sMessage.getPreviousParent();
                    List<Id> path = Arrays.asList(manager.getPathToRoot());
                    if (path.contains(previousParent)) {
                        if (this.logger.level <= 800) {
                            this.logger.log(this.endpoint.getId() + ": Rejecting subscribe message from " + sMessage.getSubscriber() + " for topic " + sMessage.getTopic() + " because we are on the subscriber's path to the root.");
                        }
                        return true;
                    }
                }
                ScribeClient[] clients = new ScribeClient[]{};
                NodeHandle[] handles = new NodeHandle[]{};
                if (manager != null) {
                    clients = manager.getClients();
                    handles = manager.getChildren();
                }
                if (Arrays.asList(handles).contains(sMessage.getSubscriber())) {
                    return false;
                }
                if (this.policy.allowSubscribe(sMessage, clients, handles)) {
                    if (this.logger.level <= 400) {
                        this.logger.log(this.endpoint.getId() + ": Hijacking subscribe message from " + sMessage.getSubscriber() + " for topic " + sMessage.getTopic());
                    }
                    this.addChild(sMessage.getTopic(), sMessage.getSubscriber(), sMessage.getId());
                    return false;
                }
                if (this.logger.level <= 400) {
                    this.logger.log(this.endpoint.getId() + ": Rejecting subscribe message from " + sMessage.getSubscriber() + " for topic " + sMessage.getTopic());
                }
                if (manager == null) {
                    return true;
                }
            } else {
                if (manager == null) {
                    return true;
                }
                ScribeClient[] clients = manager.getClients();
                for (int i = 0; i < clients.length; ++i) {
                    if (!clients[i].anycast(aMessage.getTopic(), aMessage.getContent())) continue;
                    if (this.logger.level <= 400) {
                        this.logger.log(this.endpoint.getId() + ": Accepting anycast message from " + aMessage.getSource() + " for topic " + aMessage.getTopic());
                    }
                    return false;
                }
                if (aMessage.getSource().getId().equals(this.endpoint.getId()) && message.getNextHopHandle() != null && !this.handle.equals(message.getNextHopHandle())) {
                    return true;
                }
                if (this.logger.level <= 400) {
                    this.logger.log(this.endpoint.getId() + ": Rejecting anycast message from " + aMessage.getSource() + " for topic " + aMessage.getTopic());
                }
            }
            aMessage.addVisited(this.endpoint.getLocalNodeHandle());
            this.policy.directAnycast(aMessage, manager.getParent(), manager.getChildren());
            aMessage.setSource(this.endpoint.getLocalNodeHandle());
            NodeHandle handle = aMessage.getNext();
            while (handle != null && !handle.isAlive()) {
                handle = aMessage.getNext();
            }
            if (this.logger.level <= 400) {
                this.logger.log(this.endpoint.getId() + ": Forwarding anycast message for topic " + aMessage.getTopic() + "on to " + handle);
            }
            if (handle == null) {
                if (this.logger.level <= 500) {
                    this.logger.log(this.endpoint.getId() + ": Anycast " + aMessage + " failed.");
                }
                if (aMessage instanceof SubscribeMessage) {
                    SubscribeMessage sMessage = (SubscribeMessage)aMessage;
                    if (this.logger.level <= 400) {
                        this.logger.log(this.endpoint.getId() + ": Sending SubscribeFailedMessage to " + sMessage.getSubscriber());
                    }
                    this.endpoint.route(null, new SubscribeFailedMessage(handle, sMessage.getTopic(), sMessage.getId()), sMessage.getSubscriber());
                }
            } else {
                this.endpoint.route(null, aMessage, handle);
            }
            return false;
        }
        return true;
    }

    public void deliver(Id id, Message message) {
        if (this.logger.level <= 300) {
            this.logger.log(this.endpoint.getId() + ": Deliver called with " + id + " " + message);
        }
        if (message instanceof AnycastMessage) {
            AnycastMessage aMessage = (AnycastMessage)message;
            if (aMessage.getSource().getId().equals(this.endpoint.getId())) {
                if (aMessage instanceof SubscribeMessage) {
                    SubscribeMessage sMessage = (SubscribeMessage)message;
                    this.outstanding.remove(new Integer(sMessage.getId()));
                    if (this.logger.level <= 500) {
                        this.logger.log(this.endpoint.getId() + ": Received our own subscribe message " + aMessage + " for topic " + aMessage.getTopic() + " - we are the root.");
                    }
                } else if (this.logger.level <= 900) {
                    this.logger.log(this.endpoint.getId() + ": Received unexpected delivered anycast message " + aMessage + " for topic " + aMessage.getTopic() + " - was generated by us.");
                }
            } else if (aMessage instanceof SubscribeMessage) {
                SubscribeMessage sMessage = (SubscribeMessage)aMessage;
                if (this.logger.level <= 500) {
                    this.logger.log(this.endpoint.getId() + ": Sending SubscribeFailedMessage (at root) to " + sMessage.getSubscriber());
                }
                this.endpoint.route(null, new SubscribeFailedMessage(this.handle, sMessage.getTopic(), sMessage.getId()), sMessage.getSubscriber());
            } else if (this.logger.level <= 900) {
                this.logger.log(this.endpoint.getId() + ": Received unexpected delivered anycast message " + aMessage + " for topic " + aMessage.getTopic() + " - not generated by us, but was expected to be.");
            }
        } else if (message instanceof SubscribeAckMessage) {
            SubscribeAckMessage saMessage = (SubscribeAckMessage)message;
            TopicManager manager = (TopicManager)this.topics.get(saMessage.getTopic());
            this.ackMessageReceived(saMessage);
            if (this.logger.level <= 500) {
                this.logger.log(this.endpoint.getId() + ": Received subscribe ack message from " + saMessage.getSource() + " for topic " + saMessage.getTopic());
            }
            if (!saMessage.getSource().isAlive() && this.logger.level <= 900) {
                this.logger.log(this.endpoint.getId() + ": Received subscribe ack message from " + saMessage.getSource() + " for topic " + saMessage.getTopic());
            }
            if (this.isRoot(saMessage.getTopic())) {
                if (this.logger.level <= 500) {
                    this.logger.log(this.endpoint.getId() + ": Received unexpected subscribe ack message (we are the root) from " + saMessage.getSource() + " for topic " + saMessage.getTopic());
                }
                this.endpoint.route(null, new UnsubscribeMessage(this.handle, saMessage.getTopic()), saMessage.getSource());
            } else if (manager != null) {
                if (manager.getParent() == null) {
                    manager.setParent(saMessage.getSource());
                }
                if (manager.getParent().equals(saMessage.getSource())) {
                    manager.setPathToRoot(saMessage.getPathToRoot());
                } else {
                    if (this.logger.level <= 900) {
                        this.logger.log(this.endpoint.getId() + ": Received somewhat unexpected subscribe ack message (already have parent " + manager.getParent() + ") from " + saMessage.getSource() + " for topic " + saMessage.getTopic() + " - the new policy is now to accept the message");
                    }
                    NodeHandle parent = manager.getParent();
                    manager.setParent(saMessage.getSource());
                    manager.setPathToRoot(saMessage.getPathToRoot());
                    this.endpoint.route(null, new UnsubscribeMessage(this.handle, saMessage.getTopic()), parent);
                }
            } else {
                if (this.logger.level <= 900) {
                    this.logger.log(this.endpoint.getId() + ": Received unexpected subscribe ack message from " + saMessage.getSource() + " for unknown topic " + saMessage.getTopic());
                }
                this.endpoint.route(null, new UnsubscribeMessage(this.handle, saMessage.getTopic()), saMessage.getSource());
            }
        } else if (message instanceof SubscribeLostMessage) {
            SubscribeLostMessage slMessage = (SubscribeLostMessage)message;
            this.lostMessageReceived(slMessage);
        } else if (message instanceof SubscribeFailedMessage) {
            SubscribeFailedMessage sfMessage = (SubscribeFailedMessage)message;
            this.failedMessageReceived(sfMessage);
        } else if (message instanceof PublishRequestMessage) {
            PublishRequestMessage prMessage = (PublishRequestMessage)message;
            TopicManager manager = (TopicManager)this.topics.get(prMessage.getTopic());
            if (this.logger.level <= 400) {
                this.logger.log(this.endpoint.getId() + ": Received publish request message with data " + prMessage.getContent() + " for topic " + prMessage.getTopic());
            }
            if (manager == null) {
                if (this.logger.level <= 500) {
                    this.logger.log(this.endpoint.getId() + ": Received publish request message for non-existent topic " + prMessage.getTopic() + " - dropping on floor.");
                }
            } else {
                this.deliver(prMessage.getTopic().getId(), new PublishMessage(prMessage.getSource(), prMessage.getTopic(), prMessage.getContent()));
            }
        } else if (message instanceof PublishMessage) {
            PublishMessage pMessage = (PublishMessage)message;
            TopicManager manager = (TopicManager)this.topics.get(pMessage.getTopic());
            if (this.logger.level <= 400) {
                this.logger.log(this.endpoint.getId() + ": Received publish message with data " + pMessage.getContent() + " for topic " + pMessage.getTopic());
            }
            if (manager != null && (manager.getParent() == null || manager.getParent().equals(pMessage.getSource()))) {
                pMessage.setSource(this.handle);
                ScribeClient[] clients = manager.getClients();
                for (int i = 0; i < clients.length; ++i) {
                    if (this.logger.level <= 400) {
                        this.logger.log(this.endpoint.getId() + ": Delivering publish message with data " + pMessage.getContent() + " for topic " + pMessage.getTopic() + " to client " + clients[i]);
                    }
                    clients[i].deliver(pMessage.getTopic(), pMessage.getContent());
                }
                NodeHandle[] handles = manager.getChildren();
                for (int i = 0; i < handles.length; ++i) {
                    if (this.logger.level <= 400) {
                        this.logger.log(this.endpoint.getId() + ": Forwarding publish message with data " + pMessage.getContent() + " for topic " + pMessage.getTopic() + " to child " + handles[i]);
                    }
                    this.endpoint.route(null, new PublishMessage(this.endpoint.getLocalNodeHandle(), pMessage.getTopic(), pMessage.getContent()), handles[i]);
                }
            } else {
                if (this.logger.level <= 900) {
                    this.logger.log(this.endpoint.getId() + ": Received unexpected publish message from " + pMessage.getSource() + " for unknown topic " + pMessage.getTopic());
                }
                this.endpoint.route(null, new UnsubscribeMessage(this.handle, pMessage.getTopic()), pMessage.getSource());
            }
        } else if (message instanceof UnsubscribeMessage) {
            UnsubscribeMessage uMessage = (UnsubscribeMessage)message;
            if (this.logger.level <= 500) {
                this.logger.log(this.endpoint.getId() + ": Received unsubscribe message from " + uMessage.getSource() + " for topic " + uMessage.getTopic());
            }
            this.removeChild(uMessage.getTopic(), uMessage.getSource(), false);
        } else if (message instanceof DropMessage) {
            TopicManager manager;
            DropMessage dMessage = (DropMessage)message;
            if (this.logger.level <= 500) {
                this.logger.log(this.endpoint.getId() + ": Received drop message from " + dMessage.getSource() + " for topic " + dMessage.getTopic());
            }
            if ((manager = (TopicManager)this.topics.get(dMessage.getTopic())) != null) {
                if (manager.getParent() != null && manager.getParent().equals(dMessage.getSource())) {
                    manager.setParent(null);
                    ScribeClient[] clients = manager.getClients();
                    if (clients.length > 0) {
                        this.sendSubscribe(dMessage.getTopic(), clients[0], null);
                    } else {
                        this.sendSubscribe(dMessage.getTopic(), null, null);
                    }
                } else if (this.logger.level <= 900) {
                    this.logger.log(this.endpoint.getId() + ": Received unexpected drop message from non-parent " + dMessage.getSource() + " for topic " + dMessage.getTopic() + " - ignoring");
                }
            } else if (this.logger.level <= 900) {
                this.logger.log(this.endpoint.getId() + ": Received unexpected drop message from " + dMessage.getSource() + " for unknown topic " + dMessage.getTopic() + " - ignoring");
            }
        } else if (message instanceof MaintenanceMessage) {
            if (this.logger.level <= 500) {
                this.logger.log(this.endpoint.getId() + ": Received maintenance message");
            }
            for (TopicManager manager : this.topics.values()) {
                NodeHandle parent = manager.getParent();
                if (parent == null) continue;
                this.endpoint.route(manager.getTopic().getId(), new SubscribeMessage(this.handle, manager.getTopic(), this.handle.getId(), -1, null), parent);
                parent.checkLiveness();
            }
        } else if (this.logger.level <= 900) {
            this.logger.log(this.endpoint.getId() + ": Received unknown message " + message + " - dropping on floor.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(NodeHandle handle, boolean joined) {
        Iterator e;
        Set set;
        Set set2 = set = this.topics.keySet();
        synchronized (set2) {
            e = new ArrayList(set).iterator();
        }
        while (e.hasNext()) {
            Topic topic = (Topic)e.next();
            TopicManager manager = (TopicManager)this.topics.get(topic);
            if (joined) {
                if (manager.getParent() != null) continue;
                this.sendSubscribe(topic, null, null);
                continue;
            }
            if (!this.isRoot(topic) || manager.getParent() == null) continue;
            this.endpoint.route(null, new UnsubscribeMessage(handle, topic), manager.getParent());
            manager.setParent(null);
        }
    }

    public void destroy() {
        for (TopicManager topicManager : this.topics.values()) {
            topicManager.destroy();
        }
    }

    public class TopicManager
    implements Observer,
    Destructable {
        protected Topic topic;
        protected Id[] pathToRoot;
        protected Vector clients;
        protected Vector children;
        protected NodeHandle parent;

        public TopicManager(Topic topic, ScribeClient client) {
            this(topic);
            this.addClient(client);
        }

        public TopicManager(Topic topic, NodeHandle child) {
            this(topic);
            this.addChild(child);
        }

        protected TopicManager(Topic topic) {
            this.topic = topic;
            this.clients = new Vector();
            this.children = new Vector();
            this.setPathToRoot(new Id[0]);
        }

        public Topic getTopic() {
            return this.topic;
        }

        public NodeHandle getParent() {
            return this.parent;
        }

        public ScribeClient[] getClients() {
            return this.clients.toArray(new ScribeClient[0]);
        }

        public NodeHandle[] getChildren() {
            return this.children.toArray(new NodeHandle[0]);
        }

        public Id[] getPathToRoot() {
            return this.pathToRoot;
        }

        public void setPathToRoot(Id[] pathToRoot) {
            this.pathToRoot = new Id[pathToRoot.length + 1];
            System.arraycopy(pathToRoot, 0, this.pathToRoot, 0, pathToRoot.length);
            this.pathToRoot[pathToRoot.length] = ScribeImpl.this.endpoint.getId();
            NodeHandle[] children = this.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (Arrays.asList(this.pathToRoot).contains(children[i].getId())) {
                    ScribeImpl.this.endpoint.route(null, new DropMessage(ScribeImpl.this.handle, this.topic), children[i]);
                    this.removeChild(children[i]);
                    continue;
                }
                ScribeImpl.this.endpoint.route(null, new SubscribeAckMessage(ScribeImpl.this.handle, this.topic, this.getPathToRoot(), Integer.MAX_VALUE), children[i]);
            }
        }

        public void setParent(NodeHandle handle) {
            if (handle != null && this.parent != null && ScribeImpl.this.logger.level <= 900) {
                ScribeImpl.this.logger.log(ScribeImpl.this.endpoint.getId() + ": Unexpectedly changing parents for topic " + this.topic);
            }
            if (this.parent != null) {
                this.parent.deleteObserver(this);
            }
            this.parent = handle;
            this.setPathToRoot(new Id[0]);
            if (this.parent != null && this.parent.isAlive()) {
                this.parent.addObserver(this);
            }
        }

        public boolean containsClient(ScribeClient client) {
            return this.clients.contains(client);
        }

        public void update(Observable o, Object arg) {
            if (arg.equals(NodeHandle.DECLARED_DEAD)) {
                if (this.children.contains(o)) {
                    if (ScribeImpl.this.logger.level <= 500) {
                        ScribeImpl.this.logger.log(ScribeImpl.this.endpoint.getId() + ": Child " + o + " for topic " + this.topic + " has died - removing.");
                    }
                    ScribeImpl.this.removeChild(this.topic, (NodeHandle)o);
                }
                if (o.equals(this.parent)) {
                    if (ScribeImpl.this.logger.level <= 500) {
                        ScribeImpl.this.logger.log(ScribeImpl.this.endpoint.getId() + ": Parent " + this.parent + " for topic " + this.topic + " has died - resubscribing.");
                    }
                    this.setParent(null);
                    if (this.clients.size() > 0) {
                        ScribeImpl.this.sendSubscribe(this.topic, (ScribeClient)this.clients.elementAt(0), null, ((NodeHandle)o).getId());
                    } else {
                        ScribeImpl.this.sendSubscribe(this.topic, null, null, ((NodeHandle)o).getId());
                    }
                } else {
                    if (ScribeImpl.this.logger.level <= 900) {
                        ScribeImpl.this.logger.log(ScribeImpl.this.endpoint.getId() + ": Received unexpected update from " + o);
                    }
                    o.deleteObserver(this);
                }
            }
        }

        public void addClient(ScribeClient client) {
            if (!this.clients.contains(client)) {
                this.clients.add(client);
            }
        }

        public boolean removeClient(ScribeClient client) {
            boolean unsub;
            this.clients.remove(client);
            boolean bl = unsub = this.clients.size() == 0 && this.children.size() == 0;
            if (unsub && this.parent != null) {
                this.parent.deleteObserver(this);
            }
            return unsub;
        }

        public void addChild(NodeHandle child) {
            if (!this.children.contains(child) && child.isAlive()) {
                this.children.add(child);
                child.addObserver(this);
            }
        }

        public boolean removeChild(NodeHandle child) {
            boolean unsub;
            this.children.remove(child);
            child.deleteObserver(this);
            boolean bl = unsub = this.clients.size() == 0 && this.children.size() == 0;
            if (unsub && this.parent != null) {
                this.parent.deleteObserver(this);
            }
            return unsub;
        }

        public void destroy() {
            if (this.parent != null) {
                this.parent.deleteObserver(this);
            }
            for (NodeHandle child : this.children) {
                child.deleteObserver(this);
            }
        }
    }
}

