/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.testing;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.past.Past;
import rice.p2p.past.PastImpl;
import rice.p2p.past.testing.DistPastTestContent;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.persistence.LRUCache;
import rice.persistence.MemoryStorage;
import rice.persistence.PersistentStorage;
import rice.persistence.StorageManagerImpl;

public class DistPastTest {
    public DistPastTest(int bindport, InetSocketAddress bootaddress, Environment env, int numNodes) throws Exception {
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        Past p = null;
        PersistentStorage stor = null;
        PastryIdFactory idf = new PastryIdFactory(env);
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env);
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            NodeHandle bootHandle = factory.getNodeHandle(bootaddress);
            PastryNode node = ((PastryNodeFactory)factory).newNode(bootHandle);
            while (!node.isReady()) {
                Thread.sleep(100L);
            }
            System.out.println("Finished creating new node " + node);
            stor = new PersistentStorage(idf, ".", 0x400000L, node.getEnvironment());
            p = new PastImpl(node, new StorageManagerImpl(idf, stor, new LRUCache(new MemoryStorage(idf), 524288, node.getEnvironment())), 3, "");
        }
        Thread.sleep(5000L);
        String s = "test" + env.getRandomSource().nextInt();
        DistPastTestContent dptc = new DistPastTestContent(env, idf, s);
        System.out.println("Inserting " + dptc);
        p.insert(dptc, new Continuation(){

            public void receiveResult(Object result) {
                Boolean[] results = (Boolean[])result;
                for (int ctr = 0; ctr < results.length; ++ctr) {
                    System.out.println("got " + results[ctr]);
                }
            }

            public void receiveException(Exception result) {
                result.printStackTrace();
            }
        });
        Thread.sleep(5000L);
        p.lookup(dptc.getId(), new Continuation(){

            public void receiveResult(Object result) {
                System.out.println("Got a " + result);
            }

            public void receiveException(Exception result) {
                result.printStackTrace();
            }
        });
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        try {
            int bindport = Integer.parseInt(args[0]);
            InetAddress bootaddr = InetAddress.getByName(args[1]);
            int bootport = Integer.parseInt(args[2]);
            InetSocketAddress bootaddress = new InetSocketAddress(bootaddr, bootport);
            int numNodes = Integer.parseInt(args[3]);
            DistPastTest dt = new DistPastTest(bindport, bootaddress, env, numNodes);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.lesson4.DistTutorial localbindport bootIP bootPort numNodes");
            System.out.println("example java rice.tutorial.DistTutorial 9001 pokey.cs.almamater.edu 9001 10");
            throw e;
        }
    }
}

