/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.messaging;

import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.past.PastException;
import rice.p2p.past.messaging.PastMessage;

public class MessageLostMessage
extends PastMessage {
    protected Id id;
    protected NodeHandle hint;
    protected Message message;
    private static final long serialVersionUID = -8664827144233122095L;

    public MessageLostMessage(int uid, NodeHandle local, Id id, Message message, NodeHandle hint) {
        super(uid, local, local.getId());
        this.setResponse();
        this.hint = hint;
        this.message = message;
        this.id = id;
    }

    public void returnResponse(Continuation c, Environment env, String instance) {
        Logger logger = env.getLogManager().getLogger(this.getClass(), instance);
        PastException e = new PastException("Outgoing message '" + this.message + "' to " + this.id + "/" + this.hint + " was lost - please try again.");
        if (logger.level <= 900) {
            logger.logException("ERROR: Outgoing PAST message " + this.message + " with UID " + this.getUID() + " was lost", e);
        }
        c.receiveException(e);
    }

    public String toString() {
        return "[MessageLostMessage]";
    }
}

