/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past;

import java.io.Serializable;
import java.util.Hashtable;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.PastException;
import rice.p2p.past.PastPolicy;
import rice.p2p.past.messaging.CacheMessage;
import rice.p2p.past.messaging.ContinuationMessage;
import rice.p2p.past.messaging.FetchHandleMessage;
import rice.p2p.past.messaging.FetchMessage;
import rice.p2p.past.messaging.InsertMessage;
import rice.p2p.past.messaging.LookupHandlesMessage;
import rice.p2p.past.messaging.LookupMessage;
import rice.p2p.past.messaging.MessageLostMessage;
import rice.p2p.past.messaging.PastMessage;
import rice.p2p.replication.Replication;
import rice.p2p.replication.manager.ReplicationManager;
import rice.p2p.replication.manager.ReplicationManagerClient;
import rice.p2p.replication.manager.ReplicationManagerImpl;
import rice.persistence.Cache;
import rice.persistence.StorageManager;

public class PastImpl
implements Past,
Application,
ReplicationManagerClient {
    public final int MESSAGE_TIMEOUT;
    public final double SUCCESSFUL_INSERT_THRESHOLD;
    protected Endpoint endpoint;
    protected StorageManager storage;
    protected StorageManager trash;
    protected Cache backup;
    protected int replicationFactor;
    protected ReplicationManager replicaManager;
    protected PastPolicy policy;
    private int id;
    private Hashtable outstanding;
    private Hashtable timers;
    protected IdFactory factory;
    protected String instance;
    public int inserts = 0;
    public int lookups = 0;
    public int fetchHandles = 0;
    public int other = 0;
    protected Environment environment;
    protected Logger logger;

    public PastImpl(Node node, StorageManager manager, int replicas, String instance) {
        this(node, manager, replicas, instance, new PastPolicy.DefaultPastPolicy());
    }

    public PastImpl(Node node, StorageManager manager, int replicas, String instance, PastPolicy policy) {
        this(node, manager, null, replicas, instance, policy, null);
    }

    public PastImpl(Node node, StorageManager manager, Cache backup, int replicas, String instance, PastPolicy policy, StorageManager trash) {
        this.environment = node.getEnvironment();
        this.logger = this.environment.getLogManager().getLogger(this.getClass(), instance);
        Parameters p = this.environment.getParameters();
        this.MESSAGE_TIMEOUT = p.getInt("p2p_past_messageTimeout");
        this.SUCCESSFUL_INSERT_THRESHOLD = p.getDouble("p2p_past_successfulInsertThreshold");
        this.storage = manager;
        this.backup = backup;
        this.endpoint = node.registerApplication((Application)this, instance);
        this.factory = node.getIdFactory();
        this.policy = policy;
        this.instance = instance;
        this.trash = trash;
        this.id = Integer.MIN_VALUE;
        this.outstanding = new Hashtable();
        this.timers = new Hashtable();
        this.replicationFactor = replicas;
        this.replicaManager = this.buildReplicationManager(node, instance);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Continuation[] getOutstandingMessages() {
        return this.outstanding.values().toArray(new Continuation[0]);
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    protected synchronized int getUID() {
        return this.id++;
    }

    protected Continuation getResponseContinuation(final PastMessage msg) {
        if (this.logger.level <= 400) {
            this.logger.log("Getting the Continuation to respond to the message " + msg);
        }
        final ContinuationMessage cmsg = (ContinuationMessage)msg;
        return new Continuation(){

            public void receiveResult(Object o) {
                cmsg.receiveResult(o);
                PastImpl.this.endpoint.route(null, cmsg, msg.getSource());
            }

            public void receiveException(Exception e) {
                cmsg.receiveException(e);
                PastImpl.this.endpoint.route(null, cmsg, msg.getSource());
            }
        };
    }

    protected void getHandles(Id id, int max, Continuation command) {
        NodeHandleSet set = this.endpoint.replicaSet(id, max);
        if (set.size() == max) {
            command.receiveResult(set);
        } else {
            this.sendRequest(id, (PastMessage)new LookupHandlesMessage(this.getUID(), id, max, this.getLocalNodeHandle(), id), (Continuation)new Continuation.StandardContinuation(command){

                public void receiveResult(Object o) {
                    NodeHandleSet replicas = (NodeHandleSet)o;
                    if (PastImpl.this.endpoint.replicaSet(PastImpl.this.endpoint.getLocalNodeHandle().getId(), PastImpl.this.replicationFactor + 1).size() > replicas.size()) {
                        this.parent.receiveException(new PastException("Only received " + replicas.size() + " replicas - cannot insert as we know about more nodes."));
                    } else {
                        this.parent.receiveResult(replicas);
                    }
                }
            });
        }
    }

    public NodeHandle getLocalNodeHandle() {
        return this.endpoint.getLocalNodeHandle();
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public Replication getReplication() {
        return this.replicaManager.getReplication();
    }

    public StorageManager getStorageManager() {
        return this.storage;
    }

    public String getInstance() {
        return this.instance;
    }

    protected ReplicationManager buildReplicationManager(Node node, String instance) {
        return new ReplicationManagerImpl(node, this, this.replicationFactor, instance);
    }

    protected void sendRequest(Id id, PastMessage message, Continuation command) {
        this.sendRequest(id, message, null, command);
    }

    protected void sendRequest(NodeHandle handle, PastMessage message, Continuation command) {
        this.sendRequest(null, message, handle, command);
    }

    protected void sendRequest(Id id, PastMessage message, NodeHandle hint, Continuation command) {
        if (this.logger.level <= 400) {
            this.logger.log("Sending request message " + message + " {" + message.getUID() + "} to id " + id + " via " + hint);
        }
        CancellableTask timer = this.endpoint.scheduleMessage(new MessageLostMessage(message.getUID(), this.getLocalNodeHandle(), id, message, hint), this.MESSAGE_TIMEOUT);
        this.insertPending(message.getUID(), timer, command);
        this.endpoint.route(id, message, hint);
    }

    private void insertPending(int uid, CancellableTask timer, Continuation command) {
        if (this.logger.level <= 400) {
            this.logger.log("Loading continuation " + uid + " into pending table");
        }
        this.timers.put(new Integer(uid), timer);
        this.outstanding.put(new Integer(uid), command);
    }

    private Continuation removePending(int uid) {
        CancellableTask timer;
        if (this.logger.level <= 400) {
            this.logger.log("Removing and returning continuation " + uid + " from pending table");
        }
        if ((timer = (CancellableTask)this.timers.remove(new Integer(uid))) != null) {
            timer.cancel();
        }
        return (Continuation)this.outstanding.remove(new Integer(uid));
    }

    private void handleResponse(PastMessage message) {
        Continuation command;
        if (this.logger.level <= 500) {
            this.logger.log("handling reponse message " + message + " from the request");
        }
        if ((command = this.removePending(message.getUID())) != null) {
            message.returnResponse(command, this.environment, this.instance);
        }
    }

    private void cache(PastContent content) {
        this.cache(content, new Continuation.ListenerContinuation("Caching of " + content, this.environment));
    }

    public void cache(PastContent content, Continuation command) {
        if (this.logger.level <= 400) {
            this.logger.log("Inserting PastContent object " + content + " into cache");
        }
        if (content != null && !content.isMutable()) {
            this.storage.cache(content.getId(), null, content, command);
        } else {
            command.receiveResult(new Boolean(true));
        }
    }

    protected void doInsert(final Id id, final MessageBuilder builder, Continuation command) {
        this.getHandles(id, this.replicationFactor + 1, new Continuation.StandardContinuation(command){

            public void receiveResult(Object o) {
                NodeHandleSet replicas = (NodeHandleSet)o;
                if (PastImpl.this.logger.level <= 400) {
                    PastImpl.this.logger.log("Received replicas " + replicas + " for id " + id);
                }
                Continuation.MultiContinuation multi = new Continuation.MultiContinuation(this.parent, replicas.size()){

                    public boolean isDone() throws Exception {
                        int numSuccess = 0;
                        for (int i = 0; i < this.haveResult.length; ++i) {
                            if (!this.haveResult[i] || !Boolean.TRUE.equals(this.result[i])) continue;
                            ++numSuccess;
                        }
                        if ((double)numSuccess >= PastImpl.this.SUCCESSFUL_INSERT_THRESHOLD * (double)this.haveResult.length) {
                            return true;
                        }
                        if (super.isDone()) {
                            throw new PastException("Had only " + numSuccess + " successful inserts out of " + this.result.length + " - aborting.");
                        }
                        return false;
                    }

                    public Object getResult() {
                        Boolean[] b = new Boolean[this.result.length];
                        for (int i = 0; i < b.length; ++i) {
                            b[i] = new Boolean(this.result[i] == null || Boolean.TRUE.equals(this.result[i]));
                        }
                        return b;
                    }
                };
                for (int i = 0; i < replicas.size(); ++i) {
                    PastImpl.this.sendRequest(replicas.getHandle(i), builder.buildMessage(), (Continuation)new Continuation.NamedContinuation("InsertMessage to " + replicas.getHandle(i) + " for " + id, multi.getSubContinuation(i)));
                }
            }
        });
    }

    public void insert(final PastContent obj, Continuation command) {
        if (this.logger.level <= 400) {
            this.logger.log("Inserting the object " + obj + " with the id " + obj.getId());
        }
        if (this.logger.level <= 300) {
            this.logger.log(" Inserting data of class " + obj.getClass().getName() + " under " + obj.getId().toStringFull());
        }
        this.doInsert(obj.getId(), new MessageBuilder(){

            public PastMessage buildMessage() {
                return new InsertMessage(PastImpl.this.getUID(), obj, PastImpl.this.getLocalNodeHandle(), obj.getId());
            }
        }, new Continuation.StandardContinuation(command){

            public void receiveResult(final Object array) {
                PastImpl.this.cache(obj, new Continuation.SimpleContinuation(){

                    public void receiveResult(Object o) {
                        parent.receiveResult(array);
                    }
                });
            }
        });
    }

    public void lookup(Id id, Continuation command) {
        this.lookup(id, true, command);
    }

    public void lookup(final Id id, final boolean cache, final Continuation command) {
        if (this.logger.level <= 400) {
            this.logger.log(" Performing lookup on " + id.toStringFull());
        }
        this.storage.getObject(id, new Continuation.StandardContinuation(command){

            public void receiveResult(Object o) {
                if (o != null) {
                    command.receiveResult(o);
                } else {
                    PastImpl.this.sendRequest(id, (PastMessage)new LookupMessage(PastImpl.this.getUID(), id, PastImpl.this.getLocalNodeHandle(), id), (Continuation)new Continuation.NamedContinuation("LookupMessage for " + id, this){

                        public void receiveResult(final Object o) {
                            if (o != null) {
                                if (cache) {
                                    PastImpl.this.cache((PastContent)o, new Continuation.SimpleContinuation(){

                                        public void receiveResult(Object object) {
                                            command.receiveResult(o);
                                        }
                                    });
                                } else {
                                    command.receiveResult(o);
                                }
                            } else {
                                PastImpl.this.lookupHandles(id, PastImpl.this.replicationFactor + 1, new Continuation(){

                                    public void receiveResult(Object o) {
                                        PastContentHandle[] handles = (PastContentHandle[])o;
                                        for (int i = 0; i < handles.length; ++i) {
                                            if (handles[i] == null) continue;
                                            PastImpl.this.fetch(handles[i], new Continuation.StandardContinuation(parent){

                                                public void receiveResult(final Object o) {
                                                    if (cache) {
                                                        PastImpl.this.cache((PastContent)o, new Continuation.SimpleContinuation(){

                                                            public void receiveResult(Object object) {
                                                                command.receiveResult(o);
                                                            }
                                                        });
                                                    } else {
                                                        command.receiveResult(o);
                                                    }
                                                }
                                            });
                                            return;
                                        }
                                        command.receiveResult(null);
                                    }

                                    public void receiveException(Exception e) {
                                        command.receiveException(e);
                                    }
                                });
                            }
                        }

                        public void receiveException(Exception e) {
                            this.receiveResult(null);
                        }
                    });
                }
            }
        });
    }

    public void lookupHandles(final Id id, int max, Continuation command) {
        if (this.logger.level <= 500) {
            this.logger.log("Retrieving handles of up to " + max + " replicas of the object stored in Past with id " + id);
        }
        if (this.logger.level <= 400) {
            this.logger.log("Fetching up to " + max + " handles of " + id.toStringFull());
        }
        this.getHandles(id, max, new Continuation.StandardContinuation(command){

            public void receiveResult(Object o) {
                NodeHandleSet replicas = (NodeHandleSet)o;
                if (PastImpl.this.logger.level <= 400) {
                    PastImpl.this.logger.log("Receiving replicas " + replicas + " for lookup Id " + id);
                }
                Continuation.MultiContinuation multi = new Continuation.MultiContinuation(this.parent, replicas.size()){

                    public Object getResult() {
                        PastContentHandle[] p = new PastContentHandle[this.result.length];
                        for (int i = 0; i < this.result.length; ++i) {
                            if (!(this.result[i] instanceof PastContentHandle)) continue;
                            p[i] = (PastContentHandle)this.result[i];
                        }
                        return p;
                    }
                };
                for (int i = 0; i < replicas.size(); ++i) {
                    PastImpl.this.lookupHandle(id, replicas.getHandle(i), multi.getSubContinuation(i));
                }
            }
        });
    }

    public void lookupHandle(Id id, NodeHandle handle, Continuation command) {
        if (this.logger.level <= 500) {
            this.logger.log("Retrieving handle for id " + id + " from node " + handle);
        }
        this.sendRequest(handle, (PastMessage)new FetchHandleMessage(this.getUID(), id, this.getLocalNodeHandle(), handle.getId()), (Continuation)new Continuation.NamedContinuation("FetchHandleMessage to " + handle + " for " + id, command));
    }

    public void fetch(PastContentHandle handle, Continuation command) {
        if (this.logger.level <= 500) {
            this.logger.log("Retrieving object associated with content handle " + handle);
        }
        if (this.logger.level <= 400) {
            this.logger.log("Fetching object under id " + handle.getId().toStringFull() + " on " + handle.getNodeHandle());
        }
        NodeHandle han = handle.getNodeHandle();
        this.sendRequest(han, (PastMessage)new FetchMessage(this.getUID(), handle, this.getLocalNodeHandle(), han.getId()), (Continuation)new Continuation.NamedContinuation("FetchMessage to " + handle.getNodeHandle() + " for " + handle.getId(), command));
    }

    public boolean forward(RouteMessage message) {
        LookupHandlesMessage lmsg;
        if (message.getMessage() instanceof LookupMessage) {
            LookupMessage lmsg2 = (LookupMessage)message.getMessage();
            Id id = lmsg2.getId();
            if (!lmsg2.isResponse()) {
                if (this.logger.level <= 400) {
                    this.logger.log("Lookup message " + lmsg2 + " is a request; look in the cache");
                }
                if (this.storage.exists(id)) {
                    if (this.logger.level <= 500) {
                        this.logger.log("Request for " + id + " satisfied locally - responding");
                    }
                    this.deliver(this.endpoint.getId(), lmsg2);
                    return false;
                }
            }
        } else if (message.getMessage() instanceof LookupHandlesMessage && !(lmsg = (LookupHandlesMessage)message.getMessage()).isResponse() && this.endpoint.replicaSet(lmsg.getId(), lmsg.getMax()).size() == lmsg.getMax()) {
            if (this.logger.level <= 500) {
                this.logger.log("Hijacking lookup handles request for " + lmsg.getId());
            }
            this.deliver(this.endpoint.getId(), lmsg);
            return false;
        }
        return true;
    }

    public void deliver(Id id, Message message) {
        PastMessage msg = (PastMessage)message;
        if (msg.isResponse()) {
            this.handleResponse((PastMessage)message);
        } else {
            if (this.logger.level <= 800) {
                this.logger.log("Received message " + message + " with destination " + id);
            }
            if (msg instanceof InsertMessage) {
                final InsertMessage imsg = (InsertMessage)msg;
                if (this.policy.allowInsert(imsg.getContent())) {
                    ++this.inserts;
                    this.storage.getObject(imsg.getContent().getId(), new Continuation.StandardContinuation(this.getResponseContinuation(msg)){

                        public void receiveResult(Object o) {
                            try {
                                PastContent content = imsg.getContent().checkInsert(imsg.getContent().getId(), (PastContent)o);
                                PastImpl.this.storage.store(imsg.getContent().getId(), null, content, this.parent);
                            }
                            catch (PastException e) {
                                this.parent.receiveException(e);
                            }
                        }
                    });
                } else {
                    this.getResponseContinuation(msg).receiveResult(new Boolean(false));
                }
            } else if (msg instanceof LookupMessage) {
                final LookupMessage lmsg = (LookupMessage)msg;
                ++this.lookups;
                this.storage.getObject(lmsg.getId(), new Continuation.StandardContinuation(this.getResponseContinuation(lmsg)){

                    public void receiveResult(Object o) {
                        if (PastImpl.this.logger.level <= 500) {
                            PastImpl.this.logger.log("Received object " + o + " for id " + lmsg.getId());
                        }
                        this.parent.receiveResult(o);
                        if (lmsg.getPreviousNodeHandle() != null && o != null && !((PastContent)o).isMutable()) {
                            NodeHandle handle = lmsg.getPreviousNodeHandle();
                            if (PastImpl.this.logger.level <= 500) {
                                PastImpl.this.logger.log("Pushing cached copy of " + ((PastContent)o).getId() + " to " + handle);
                            }
                            CacheMessage cacheMessage = new CacheMessage(PastImpl.this.getUID(), (PastContent)o, PastImpl.this.getLocalNodeHandle(), handle.getId());
                        }
                    }
                });
            } else if (msg instanceof LookupHandlesMessage) {
                LookupHandlesMessage lmsg = (LookupHandlesMessage)msg;
                NodeHandleSet set = this.endpoint.replicaSet(lmsg.getId(), lmsg.getMax());
                if (this.logger.level <= 400) {
                    this.logger.log("Returning replica set " + set + " for lookup handles of id " + lmsg.getId() + " max " + lmsg.getMax() + " at " + this.endpoint.getId());
                }
                this.getResponseContinuation(msg).receiveResult(set);
            } else if (msg instanceof FetchMessage) {
                FetchMessage fmsg = (FetchMessage)msg;
                ++this.lookups;
                this.storage.getObject(fmsg.getHandle().getId(), this.getResponseContinuation(msg));
            } else if (msg instanceof FetchHandleMessage) {
                final FetchHandleMessage fmsg = (FetchHandleMessage)msg;
                ++this.fetchHandles;
                this.storage.getObject(fmsg.getId(), new Continuation.StandardContinuation(this.getResponseContinuation(msg)){

                    public void receiveResult(Object o) {
                        PastContent content = (PastContent)o;
                        if (content != null) {
                            if (PastImpl.this.logger.level <= 500) {
                                PastImpl.this.logger.log("Retrieved data for fetch handles of id " + fmsg.getId());
                            }
                            this.parent.receiveResult(content.getHandle(PastImpl.this));
                        } else {
                            this.parent.receiveResult(null);
                        }
                    }
                });
            } else if (msg instanceof CacheMessage) {
                this.cache(((CacheMessage)msg).getContent());
            } else if (this.logger.level <= 1000) {
                this.logger.log("ERROR - Received message " + msg + "of unknown type.");
            }
        }
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    public void fetch(final Id id, NodeHandle hint, Continuation command) {
        if (this.logger.level <= 400) {
            this.logger.log("Sending out replication fetch request for the id " + id);
        }
        this.policy.fetch(id, hint, this.backup, this, new Continuation.StandardContinuation(command){

            public void receiveResult(Object o) {
                if (o == null) {
                    if (PastImpl.this.logger.level <= 900) {
                        PastImpl.this.logger.log("Could not fetch id " + id + " - policy returned null in namespace " + PastImpl.this.instance);
                    }
                    this.parent.receiveResult(new Boolean(false));
                } else {
                    if (PastImpl.this.logger.level <= 300) {
                        PastImpl.this.logger.log("inserting replica of id " + id);
                    }
                    if (!(o instanceof PastContent) && PastImpl.this.logger.level <= 900) {
                        PastImpl.this.logger.log("ERROR! Not PastContent " + o.getClass().getName() + " " + o);
                    }
                    PastImpl.this.storage.getStorage().store(((PastContent)o).getId(), null, (PastContent)o, this.parent);
                }
            }
        });
    }

    public void remove(final Id id, Continuation command) {
        if (this.backup != null) {
            this.storage.getObject(id, new Continuation.StandardContinuation(command){

                public void receiveResult(Object o) {
                    PastImpl.this.backup.cache(id, PastImpl.this.storage.getMetadata(id), (Serializable)o, new Continuation.StandardContinuation(this.parent){

                        public void receiveResult(Object o) {
                            PastImpl.this.storage.unstore(id, this.parent);
                        }
                    });
                }
            });
        } else {
            this.storage.unstore(id, command);
        }
    }

    public IdSet scan(IdRange range) {
        return this.storage.getStorage().scan(range);
    }

    public IdSet scan() {
        return this.storage.getStorage().scan();
    }

    public boolean exists(Id id) {
        return this.storage.getStorage().exists(id);
    }

    public void existsInOverlay(Id id, Continuation command) {
        this.lookupHandles(id, this.replicationFactor + 1, new Continuation.StandardContinuation(command){

            public void receiveResult(Object result) {
                Object[] results = (Object[])result;
                for (int i = 0; i < results.length; ++i) {
                    if (!(results[i] instanceof PastContentHandle)) continue;
                    this.parent.receiveResult(Boolean.TRUE);
                    return;
                }
                this.parent.receiveResult(Boolean.FALSE);
            }
        });
    }

    public void reInsert(Id id, Continuation command) {
        this.storage.getObject(id, new Continuation.StandardContinuation(command){

            public void receiveResult(Object o) {
                PastImpl.this.insert((PastContent)o, new Continuation.StandardContinuation(this.parent){

                    public void receiveResult(Object result) {
                        Boolean[] results = (Boolean[])result;
                        for (int i = 0; i < results.length; ++i) {
                            if (!results[i].booleanValue()) continue;
                            this.parent.receiveResult(Boolean.TRUE);
                            return;
                        }
                        this.parent.receiveResult(Boolean.FALSE);
                    }
                });
            }
        });
    }

    public static interface MessageBuilder {
        public PastMessage buildMessage();
    }
}

