/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.multiring.MultiringNodeHandle;
import rice.p2p.multiring.RingId;

public class MultiringRouteMessage
implements RouteMessage {
    protected RouteMessage message;
    protected Id ringId;

    protected MultiringRouteMessage(Id ringId, RouteMessage message) {
        this.ringId = ringId;
        this.message = message;
        if (ringId instanceof RingId || message instanceof MultiringRouteMessage) {
            throw new IllegalArgumentException("Illegal creation of MRRouteMessage: " + ringId.getClass() + ", " + message.getClass());
        }
    }

    protected RouteMessage getRouteMessage() {
        return this.message;
    }

    public Id getDestinationId() {
        return RingId.build(this.ringId, this.message.getDestinationId());
    }

    public NodeHandle getNextHopHandle() {
        return new MultiringNodeHandle(this.ringId, this.message.getNextHopHandle());
    }

    public Message getMessage() {
        return this.message.getMessage();
    }

    public void setDestinationId(Id id) {
        this.message.setDestinationId(((RingId)id).getId());
    }

    public void setNextHopHandle(NodeHandle nextHop) {
        this.message.setNextHopHandle(((MultiringNodeHandle)nextHop).getHandle());
    }

    public void setMessage(Message message) {
        this.message.setMessage(message);
    }
}

