/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.multiring.MultiringNodeHandle;
import rice.p2p.multiring.MultiringRouteMessage;
import rice.p2p.multiring.RingId;

public class MultiringApplication
implements Application {
    protected Application application;
    protected Id ringId;

    protected MultiringApplication(Id ringId, Application application) {
        this.application = application;
        this.ringId = ringId;
        if (ringId instanceof RingId || application instanceof MultiringApplication) {
            throw new IllegalArgumentException("Illegal creation of MRApplication: " + ringId.getClass() + ", " + application.getClass());
        }
    }

    public boolean forward(RouteMessage message) {
        return this.application.forward(new MultiringRouteMessage(this.ringId, message));
    }

    public void deliver(Id id, Message message) {
        if (id != null) {
            this.application.deliver(RingId.build(this.ringId, id), message);
        } else {
            this.application.deliver(null, message);
        }
    }

    public void update(NodeHandle handle, boolean joined) {
        this.application.update(new MultiringNodeHandle(this.ringId, handle), joined);
    }
}

