/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import rice.environment.logging.Logger;
import rice.p2p.glacier.Fragment;

public class Manifest
implements Serializable {
    protected transient byte[] objectHash;
    protected transient byte[][] fragmentHash;
    protected transient byte[] signature;
    protected long expirationDate;
    static final long serialVersionUID = -436805143199825662L;

    public Manifest(byte[] objectHash, byte[][] fragmentHash, long expirationDate) {
        this.objectHash = objectHash;
        this.fragmentHash = fragmentHash;
        this.expirationDate = expirationDate;
        this.signature = null;
    }

    public byte[] getObjectHash() {
        return this.objectHash;
    }

    public byte[] getFragmentHash(int fragmentID) {
        return this.fragmentHash[fragmentID];
    }

    public byte[][] getFragmentHashes() {
        return this.fragmentHash;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public long getExpiration() {
        return this.expirationDate;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public void update(long newExpirationDate, byte[] newSignature) {
        this.expirationDate = newExpirationDate;
        this.signature = newSignature;
    }

    public boolean validatesFragment(Fragment fragment, int fragmentID, Logger logger) {
        if (fragmentID < 0 || fragmentID >= this.fragmentHash.length) {
            return false;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            if (logger.level <= 1000) {
                logger.log("*** SHA-1 not supported ***" + this.toStringFull());
            }
            return false;
        }
        md.reset();
        md.update(fragment.getPayload());
        byte[] thisHash = md.digest();
        if (thisHash.length != this.fragmentHash[fragmentID].length) {
            if (logger.level <= 900) {
                logger.log("*** LENGTH MISMATCH: " + thisHash.length + " != " + this.fragmentHash[fragmentID].length + " ***" + this.toStringFull());
            }
            return false;
        }
        for (int i = 0; i < thisHash.length; ++i) {
            if (thisHash[i] == this.fragmentHash[fragmentID][i]) continue;
            String s = "*** HASH MISMATCH: POS#" + i + ", " + thisHash[i] + " != " + this.fragmentHash[fragmentID][i] + " ***\n";
            s = s + "Hash: ";
            for (int j = 0; j < thisHash.length; ++j) {
                s = s + thisHash[j];
            }
            s = s + "\n" + this.toStringFull();
            if (logger.level <= 900) {
                logger.log(s);
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return "[Manifest obj=[" + Manifest.dump(this.objectHash, false) + "] expires=" + this.expirationDate + "]";
    }

    public String toStringFull() {
        String result = "";
        result = result + "Manifest (expires " + this.expirationDate + ")\n";
        result = result + "  - objectHash = [" + Manifest.dump(this.objectHash, false) + "]\n";
        result = result + "  - signature  = [" + Manifest.dump(this.signature, false) + "]\n";
        for (int i = 0; i < this.fragmentHash.length; ++i) {
            result = result + "  - fragmHash" + i + " = [" + Manifest.dump(this.fragmentHash[i], false) + "]\n";
        }
        return result;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(this.objectHash.length);
        oos.writeInt(this.fragmentHash.length);
        oos.writeInt(this.fragmentHash[0].length);
        oos.writeInt(this.signature.length);
        oos.write(this.objectHash);
        int dim1 = this.fragmentHash.length;
        int dim2 = this.fragmentHash[0].length;
        byte[] fragmentHashField = new byte[dim1 * dim2];
        for (int i = 0; i < dim1; ++i) {
            for (int j = 0; j < dim2; ++j) {
                fragmentHashField[i * dim2 + j] = this.fragmentHash[i][j];
            }
        }
        oos.write(fragmentHashField);
        oos.write(this.signature);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        int objectHashLength = ois.readInt();
        int fragmentHashLength = ois.readInt();
        int fragmentHashSubLength = ois.readInt();
        int signatureLength = ois.readInt();
        this.objectHash = new byte[objectHashLength];
        ois.readFully(this.objectHash, 0, objectHashLength);
        byte[] fragmentHashField = new byte[fragmentHashLength * fragmentHashSubLength];
        ois.readFully(fragmentHashField, 0, fragmentHashLength * fragmentHashSubLength);
        this.fragmentHash = new byte[fragmentHashLength][fragmentHashSubLength];
        for (int i = 0; i < fragmentHashLength; ++i) {
            for (int j = 0; j < fragmentHashSubLength; ++j) {
                this.fragmentHash[i][j] = fragmentHashField[i * fragmentHashSubLength + j];
            }
        }
        this.signature = new byte[signatureLength];
        ois.readFully(this.signature, 0, signatureLength);
    }

    private static String dump(byte[] data, boolean linebreak) {
        String hex = "0123456789ABCDEF";
        String result = "";
        for (int i = 0; i < data.length; ++i) {
            int d = data[i];
            if (d < 0) {
                d += 256;
            }
            int hi = d >> 4;
            int lo = d & 0xF;
            result = result + "0123456789ABCDEF".charAt(hi) + "0123456789ABCDEF".charAt(lo);
            if (linebreak && (i % 16 == 15 || i == data.length - 1)) {
                result = result + "\n";
                continue;
            }
            if (i == data.length - 1) continue;
            result = result + " ";
        }
        return result;
    }
}

