/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.glacier.ErasureCodec;
import rice.p2p.glacier.Fragment;
import rice.p2p.glacier.VersionKey;
import rice.p2p.glacier.v2.GlacierPolicy;
import rice.p2p.glacier.v2.Manifest;

public class GlacierDefaultPolicy
implements GlacierPolicy {
    protected ErasureCodec codec;
    protected String instance;
    protected Environment environment;
    protected Logger logger;

    public GlacierDefaultPolicy(ErasureCodec codec, String instance, Environment env) {
        this.codec = codec;
        this.instance = instance;
        this.environment = env;
        this.logger = this.environment.getLogManager().getLogger(GlacierDefaultPolicy.class, instance);
    }

    public boolean checkSignature(Manifest manifest, VersionKey key) {
        if (manifest.getSignature() == null) {
            return false;
        }
        return Arrays.equals(manifest.getSignature(), key.toByteArray());
    }

    protected void signManifest(Manifest manifest, VersionKey key) {
        manifest.setSignature(key.toByteArray());
    }

    public void prefetchLocalObject(VersionKey key, Continuation command) {
        command.receiveResult(null);
    }

    public Serializable decodeObject(Fragment[] fragments) {
        return this.codec.decode(fragments);
    }

    public Manifest[] createManifests(VersionKey key, Serializable obj, Fragment[] fragments, long expiration) {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(obj);
            objectStream.flush();
            bytes = byteStream.toByteArray();
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.log("Cannot serialize object: " + ioe);
            }
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            if (this.logger.level <= 900) {
                this.logger.log("No SHA support!");
            }
            return null;
        }
        byte[][] fragmentHash = new byte[fragments.length][];
        for (int i = 0; i < fragments.length; ++i) {
            md.reset();
            md.update(fragments[i].getPayload());
            fragmentHash[i] = md.digest();
        }
        byte[] objectHash = null;
        md.reset();
        md.update(bytes);
        objectHash = md.digest();
        Manifest[] manifests = new Manifest[fragments.length];
        for (int i = 0; i < fragments.length; ++i) {
            manifests[i] = new Manifest(objectHash, fragmentHash, expiration);
            this.signManifest(manifests[i], key);
        }
        return manifests;
    }

    public Fragment[] encodeObject(Serializable obj, boolean[] generateFragment) {
        if (this.logger.level <= 400) {
            this.logger.log("Serialize object: " + obj);
        }
        byte[] bytes = null;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(obj);
            objectStream.flush();
            bytes = byteStream.toByteArray();
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.log("Cannot serialize object: " + ioe);
            }
            return null;
        }
        if (this.logger.level <= 400) {
            this.logger.log("Create fragments: " + obj);
        }
        Fragment[] fragments = this.codec.encode(bytes, generateFragment);
        if (this.logger.level <= 400) {
            this.logger.log("Completed: " + obj);
        }
        return fragments;
    }

    public Manifest updateManifest(VersionKey key, Manifest manifest, long newExpiration) {
        if (!this.checkSignature(manifest, key)) {
            return null;
        }
        Manifest newManifest = new Manifest(manifest.getObjectHash(), manifest.getFragmentHashes(), newExpiration);
        this.signManifest(newManifest, key);
        return newManifest;
    }
}

