/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2;

import java.io.Serializable;
import java.util.Arrays;
import rice.environment.logging.Logger;
import rice.environment.random.RandomSource;

public class BloomFilter
implements Serializable {
    private byte[] bitfield;
    private int[] hashParams;
    private static final long serialVersionUID = -3938913031743354080L;

    public BloomFilter(int length, int[] hashParams) {
        this.bitfield = new byte[(length + 7) / 8];
        Arrays.fill(this.bitfield, (byte)0);
        this.hashParams = hashParams;
    }

    public BloomFilter(int length, int numHashes, RandomSource rand) {
        int i;
        this.bitfield = new byte[(length + 7) / 8];
        Arrays.fill(this.bitfield, (byte)0);
        int numPrimeCandidates = numHashes * 100;
        if (numPrimeCandidates >= length - 5) {
            numPrimeCandidates = length - 5;
        }
        int maxFactor = (int)Math.sqrt(length);
        int offset = length - numPrimeCandidates + 1;
        boolean[] isPrimeH = new boolean[numPrimeCandidates];
        boolean[] isPrimeL = new boolean[maxFactor + 1];
        Arrays.fill(isPrimeH, true);
        Arrays.fill(isPrimeL, true);
        for (i = 2; i <= maxFactor; ++i) {
            int j;
            if (!isPrimeL[i]) continue;
            for (j = 0; j <= maxFactor / i; ++j) {
                isPrimeL[j * i] = false;
            }
            for (j = (offset + i - 1) / i; j <= length / i; ++j) {
                isPrimeH[j * i - offset] = false;
            }
        }
        this.hashParams = new int[numHashes];
        for (i = 0; i < numHashes; ++i) {
            int index = rand.nextInt(numPrimeCandidates);
            while (!isPrimeH[index]) {
                index = (index + 1) % numPrimeCandidates;
            }
            isPrimeH[index] = false;
            this.hashParams[i] = offset + index;
        }
    }

    private int[] getHashes(byte[] data) {
        long cache = 0L;
        int ctr = 0;
        int[] hash = new int[this.hashParams.length];
        Arrays.fill(hash, 0);
        for (int i = 0; i < data.length; ++i) {
            cache = (cache << 8) + (long)data[i] + (long)(data[i] < 0 ? 256 : 0);
            if (++ctr != 7 && i != data.length - 1) continue;
            for (int j = 0; j < this.hashParams.length; ++j) {
                int n = j;
                hash[n] = (int)((long)hash[n] + cache % (long)this.hashParams[j]);
            }
            ctr = 0;
            cache = 0L;
        }
        for (int j = 0; j < this.hashParams.length; ++j) {
            hash[j] = hash[j] % this.hashParams[j];
        }
        return hash;
    }

    private void dump(Logger logger) {
        String s = "";
        for (int i = 0; i < this.bitfield.length * 8; ++i) {
            s = (this.bitfield[i / 8] & 1 << (i & 7)) == 0 ? s + "0" : s + "1";
        }
        s = s + "\n";
        if (logger.level <= 800) {
            logger.log(s);
        }
    }

    public void add(byte[] data) {
        int[] hash = this.getHashes(data);
        for (int i = 0; i < this.hashParams.length; ++i) {
            int n = hash[i] / 8;
            this.bitfield[n] = (byte)(this.bitfield[n] | 1 << (hash[i] & 7));
        }
    }

    public boolean contains(byte[] data) {
        int[] hash = this.getHashes(data);
        for (int i = 0; i < this.hashParams.length; ++i) {
            if ((this.bitfield[hash[i] / 8] & 1 << (hash[i] & 7)) != 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String result = "[BV " + this.bitfield.length * 8 + "bit = { ";
        for (int i = 0; i < this.hashParams.length; ++i) {
            result = result + (i == 0 ? "" : ", ") + this.hashParams[i];
        }
        result = result + " }]";
        return result;
    }
}

