/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier;

import java.util.Iterator;
import java.util.SortedMap;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.glacier.VersionKey;
import rice.p2p.glacier.VersionKeyRange;
import rice.p2p.util.RedBlackMap;

public class VersionKeySet
implements IdSet {
    private SortedMap idSet;
    private VersionKey cachedHash;
    private boolean validHash;

    public VersionKeySet() {
        this.idSet = new RedBlackMap();
        this.validHash = false;
    }

    public VersionKeySet(VersionKeySet o) {
        this.idSet = new RedBlackMap(o.idSet);
        this.cachedHash = o.cachedHash;
        this.validHash = o.validHash;
    }

    protected VersionKeySet(SortedMap s) {
        this.idSet = s;
        this.validHash = false;
    }

    public boolean isMember(Id id) {
        return this.idSet.containsKey(id);
    }

    public Iterator getIterator() {
        return this.idSet.keySet().iterator();
    }

    public byte[] getHash() {
        throw new RuntimeException("VersionKeySet.getHash() is not supported!");
    }

    public boolean isMemberId(Id id) {
        return this.isMember(id);
    }

    public int numElements() {
        return this.idSet.size();
    }

    public void addMember(Id id) {
        this.idSet.put(id, null);
        this.validHash = false;
    }

    public void removeMember(Id id) {
        this.idSet.remove(id);
        this.validHash = false;
    }

    public VersionKey minMember() {
        return (VersionKey)this.idSet.firstKey();
    }

    public VersionKey maxMember() {
        return (VersionKey)this.idSet.lastKey();
    }

    public VersionKeySet subSet(Id from, Id to) {
        return new VersionKeySet(this.idSet.subMap(from, to));
    }

    public VersionKeySet subSet(VersionKeyRange range) {
        if (range.isEmpty()) {
            return new VersionKeySet();
        }
        if (range.getCCWId().equals(range.getCWId())) {
            return this;
        }
        return this.subSet(range.getCCWId(), range.getCWId());
    }

    public String toString() {
        Iterator it = this.getIterator();
        String s = "[ IdSet:  ]";
        return s;
    }

    public void addId(Id id) {
        this.addMember(id);
    }

    public void removeId(Id id) {
        this.removeMember((VersionKey)id);
    }

    public IdSet subSet(IdRange range) {
        return this.subSet((VersionKeyRange)range);
    }

    public byte[] hash() {
        return this.getHash();
    }

    public Object clone() {
        return new VersionKeySet(this);
    }

    public IdSet build() {
        return new VersionKeySet();
    }

    public Id[] asArray() {
        return this.idSet.keySet().toArray(new Id[0]);
    }
}

