/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.processing.simple;

import rice.Continuation;
import rice.Executable;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.time.TimeSource;
import rice.selector.SelectorManager;

public class ProcessingRequest
implements Runnable {
    Continuation c;
    Executable r;
    TimeSource timeSource;
    SelectorManager selectorManager;
    Logger logger;

    public ProcessingRequest(Executable r, Continuation c, LogManager logging, TimeSource timeSource, SelectorManager selectorManager) {
        this.r = r;
        this.c = c;
        this.logger = logging.getLogger(this.getClass(), null);
        this.timeSource = timeSource;
        this.selectorManager = selectorManager;
    }

    public void returnResult(Object o) {
        this.c.receiveResult(o);
    }

    public void returnError(Exception e) {
        this.c.receiveException(e);
    }

    public void run() {
        if (this.logger.level <= 400) {
            this.logger.log("COUNT: Starting execution of " + this);
        }
        try {
            long start = this.timeSource.currentTimeMillis();
            final Object result = this.r.execute();
            if (this.logger.level <= 300) {
                this.logger.log("QT: " + (this.timeSource.currentTimeMillis() - start) + " " + this.r.toString());
            }
            this.selectorManager.invoke(new Runnable(){

                public void run() {
                    ProcessingRequest.this.returnResult(result);
                }

                public String toString() {
                    return "return ProcessingRequest for " + ProcessingRequest.this.r + " to " + ProcessingRequest.this.c;
                }
            });
        }
        catch (Exception e) {
            this.selectorManager.invoke(new Runnable(){

                public void run() {
                    ProcessingRequest.this.returnError(e);
                }

                public String toString() {
                    return "return ProcessingRequest for " + ProcessingRequest.this.r + " to " + ProcessingRequest.this.c;
                }
            });
        }
        if (this.logger.level <= 400) {
            this.logger.log("COUNT: Done execution of " + this);
        }
    }
}

