/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.processing;

import rice.Continuation;
import rice.selector.SelectorManager;

public abstract class WorkRequest
implements Runnable {
    private Continuation c;
    private SelectorManager selectorManager;

    public WorkRequest(Continuation c, SelectorManager sm) {
        this.c = c;
        this.selectorManager = sm;
    }

    public WorkRequest() {
    }

    public void returnResult(Object o) {
        this.c.receiveResult(o);
    }

    public void returnError(Exception e) {
        this.c.receiveException(e);
    }

    public void run() {
        try {
            final Object result = this.doWork();
            this.selectorManager.invoke(new Runnable(){

                public void run() {
                    WorkRequest.this.returnResult(result);
                }

                public String toString() {
                    return "invc result of " + WorkRequest.this.c;
                }
            });
        }
        catch (Exception e) {
            this.selectorManager.invoke(new Runnable(){

                public void run() {
                    WorkRequest.this.returnError(e);
                }

                public String toString() {
                    return "invc error of " + WorkRequest.this.c;
                }
            });
        }
    }

    public abstract Object doWork() throws Exception;
}

