/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.logging.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.text.DateFormatter;
import rice.environment.logging.AbstractLogManager;
import rice.environment.logging.Logger;
import rice.environment.logging.simple.SimpleLogger;
import rice.environment.params.Parameters;
import rice.environment.time.TimeSource;
import rice.selector.SelectorManager;
import rice.selector.TimerTask;

public class RotatingLogManager
extends AbstractLogManager {
    protected TimerTask rotateTask;
    protected TimerTask sizeRotateTask;

    public RotatingLogManager(TimeSource timeSource, Parameters params) {
        this(timeSource, params, "", null);
    }

    public RotatingLogManager(TimeSource timeSource, Parameters params, String prefix, String dateFormat) {
        super(AbstractLogManager.nullPrintStream, timeSource, params, prefix, dateFormat);
        this.rotate();
    }

    public void startRotateTask(SelectorManager sm) {
        if (this.rotateTask == null) {
            this.rotateTask = new LogRotationTask();
            sm.getTimer().schedule(this.rotateTask, this.params.getInt("log_rotate_interval"), this.params.getInt("log_rotate_interval"));
            if (this.params.contains("log_rotate_size_check_interval") && this.sizeRotateTask == null) {
                this.sizeRotateTask = new LogSizeRotationTask();
                sm.getTimer().schedule(this.sizeRotateTask, this.params.getInt("log_rotate_size_check_interval"), this.params.getInt("log_rotate_size_check_interval"));
            }
        } else {
            throw new RuntimeException("Task already started");
        }
    }

    public void cancelRotateTask() {
        this.rotateTask.cancel();
        this.rotateTask = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rotate() {
        RotatingLogManager rotatingLogManager = this;
        synchronized (rotatingLogManager) {
            String filename;
            File oldfile;
            PrintStream oldps = this.ps;
            String dateFormat = this.params.getString("log_rotating_date_format");
            DateFormatter dateFormatter = null;
            if (dateFormat != null && !dateFormat.equals("")) {
                dateFormatter = new DateFormatter(new SimpleDateFormat(dateFormat));
            }
            if ((oldfile = new File(filename = this.params.getString("log_rotate_filename"))).exists()) {
                long filedate = oldfile.lastModified();
                String rot_filename = filename + "." + filedate;
                if (dateFormatter != null) {
                    try {
                        rot_filename = filename + "." + dateFormatter.valueToString(new Date(filedate));
                    }
                    catch (ParseException pe) {
                        pe.printStackTrace();
                    }
                }
                oldfile.renameTo(new File(rot_filename));
            }
            try {
                this.ps = new PrintStream(new FileOutputStream(oldfile, true), true);
                if (oldps != null) {
                    oldps.close();
                }
            }
            catch (FileNotFoundException e) {
                if (this.ps != oldps) {
                    this.ps = oldps;
                }
                System.err.println("could not rotate log " + filename + " because of " + e);
            }
        }
    }

    protected Logger constructLogger(String clazz, int level, boolean useDefault) {
        return new SimpleLogger(clazz, this, level, useDefault);
    }

    private class LogSizeRotationTask
    extends TimerTask {
        private LogSizeRotationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RotatingLogManager rotatingLogManager = RotatingLogManager.this;
            synchronized (rotatingLogManager) {
                if (new File(RotatingLogManager.this.params.getString("log_rotate_filename")).length() >= RotatingLogManager.this.params.getLong("log_rotate_max_size")) {
                    RotatingLogManager.this.rotate();
                }
            }
        }
    }

    private class LogRotationTask
    extends TimerTask {
        private LogRotationTask() {
        }

        public void run() {
            RotatingLogManager.this.rotate();
        }
    }
}

