/*
 * Decompiled with CFR 0.152.
 */
package rice.environment;

import java.io.IOException;
import java.util.HashSet;
import rice.Destructable;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.logging.file.FileLogManager;
import rice.environment.logging.simple.SimpleLogManager;
import rice.environment.params.Parameters;
import rice.environment.params.simple.SimpleParameters;
import rice.environment.processing.Processor;
import rice.environment.processing.sim.SimProcessor;
import rice.environment.processing.simple.SimpleProcessor;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.environment.time.TimeSource;
import rice.environment.time.simple.SimpleTimeSource;
import rice.environment.time.simulated.DirectTimeSource;
import rice.selector.SelectorManager;

public class Environment
implements Destructable {
    private SelectorManager selectorManager;
    private Processor processor;
    private RandomSource randomSource;
    private TimeSource time;
    private LogManager logManager;
    private Parameters params;
    private Logger logger;
    private HashSet destructables = new HashSet();
    public static final String[] defaultParamFileArray = new String[]{"freepastry"};

    public Environment(SelectorManager sm, Processor proc, RandomSource rs, TimeSource time, LogManager lm, Parameters params) {
        this.selectorManager = sm;
        this.randomSource = rs;
        this.time = time;
        this.logManager = lm;
        this.params = params;
        this.processor = proc;
        if (params == null) {
            throw new IllegalArgumentException("params cannot be null");
        }
        this.chooseDefaults();
        this.addDestructable(this.selectorManager);
        this.addDestructable(this.processor);
        this.logger = this.logManager.getLogger(this.getClass(), null);
    }

    public Environment(String[] orderedDefaultFiles, String paramFileName) {
        this(null, null, null, null, null, new SimpleParameters(orderedDefaultFiles, paramFileName));
    }

    public Environment(String paramFileName) {
        this(defaultParamFileArray, paramFileName);
    }

    public Environment() {
        this(null);
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public RandomSource getRandomSource() {
        return this.randomSource;
    }

    public TimeSource getTimeSource() {
        return this.time;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public Parameters getParameters() {
        return this.params;
    }

    protected void chooseDefaults() {
        if (this.time == null) {
            this.time = Environment.generateDefaultTimeSource();
        }
        if (this.logManager == null) {
            this.logManager = Environment.generateDefaultLogManager(this.time, this.params);
        }
        if (this.randomSource == null) {
            this.randomSource = Environment.generateDefaultRandomSource(this.params, this.logManager);
        }
        if (this.selectorManager == null) {
            this.selectorManager = Environment.generateDefaultSelectorManager(this.time, this.logManager);
        }
        if (this.processor == null) {
            this.processor = Environment.generateDefaultProcessor();
        }
    }

    public void destroy() {
        block3: {
            try {
                this.params.store();
            }
            catch (IOException ioe) {
                if (this.logger.level > 900) break block3;
                this.logger.logException("Error during shutdown", ioe);
            }
        }
        for (Destructable d : this.destructables) {
            d.destroy();
        }
        this.selectorManager.destroy();
        this.processor.destroy();
    }

    public void addDestructable(Destructable destructable) {
        this.destructables.add(destructable);
    }

    public void removeDestructable(Destructable destructable) {
        this.destructables.remove(destructable);
    }

    public static Environment directEnvironment() {
        SimpleParameters params = new SimpleParameters(defaultParamFileArray, null);
        DirectTimeSource dts = new DirectTimeSource(params);
        LogManager lm = Environment.generateDefaultLogManager(dts, params);
        dts.setLogManager(lm);
        SelectorManager selector = Environment.generateDefaultSelectorManager(dts, lm);
        SimProcessor proc = new SimProcessor(selector);
        Environment ret = new Environment(selector, proc, null, dts, lm, params);
        return ret;
    }

    public static RandomSource generateDefaultRandomSource(Parameters params, LogManager logging) {
        SimpleRandomSource randomSource = params.getString("random_seed").equalsIgnoreCase("clock") ? new SimpleRandomSource(logging) : new SimpleRandomSource(params.getLong("random_seed"), logging);
        return randomSource;
    }

    public static TimeSource generateDefaultTimeSource() {
        return new SimpleTimeSource();
    }

    public static LogManager generateDefaultLogManager(TimeSource time, Parameters params) {
        if (params.getBoolean("environment_logToFile")) {
            return new FileLogManager(time, params);
        }
        return new SimpleLogManager(time, params);
    }

    public static SelectorManager generateDefaultSelectorManager(TimeSource time, LogManager logging) {
        return new SelectorManager("Default", time, logging);
    }

    public static Processor generateDefaultProcessor() {
        return new SimpleProcessor("Default");
    }
}

